<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\PushNotification;
use Intervention\Image\Facades\Image;

class NotificationController extends Controller
{
    public function index()
    {
        return view('admin.pushNotification.add');
    }

    /**
     * Write code on Method
     *
     * @return response()
     */


    public function sendNotification(Request $request)
    {
        try {

            if ($request->agent_id) {
                $firebaseToken = User::where('id', $request->agent_id)->whereNotNull('device_token')->select('device_token')->get();
            } else {
                $firebaseToken = User::whereNotNull('device_token')->select('device_token')->get();
            }
            $SERVER_API_KEY = env('FCM_SERVER_KEY');

            if (count($firebaseToken->toArray()) == 0) return response()->json(['message' => 'Notification Error, No user token registered', 'status' => false], 200);

            $firebaseToken = collect($firebaseToken->toArray())->map(function ($item) {
                return $item["device_token"];
            });

            $data = [
                "registration_ids" => $firebaseToken,
                "notification" => [
                    "title" => $request->title,
                    "body" => $request->body,
                    "image" => $request->image,
                ],
                "data" => [
                    "route" => "notification"
                ]
            ];
            $dataString = json_encode($data);

            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];

            if ($request->hasFile('image')) {
                $image = $request->image;
                $rand = rand(100, 999);
                $input['file'] = time() . $rand . '.' . $image->getClientOriginalExtension();

                $destinationPath = public_path('uploads/notification');

                $imgFile = Image::make($image->getRealPath());
                $img = Image::make($image)->save($destinationPath . '/' . $input['file']);
                $img->save();
            } else {
                $input['file'] = "";
            }
            // ******** Image uploade end ********

            if ($request->agent_id) {
                $notification = new PushNotification;
                $notification->title = $request->title;
                $notification->message = $request->body;
                $notification->agent_id = $request->agent_id;
                $notification->image = $input['file'];
                $res = $notification->save();
            } else {
                $notification = new PushNotification;
                $notification->title = $request->title;
                $notification->message = $request->body;
                $notification->image = $input['file'];
                $res = $notification->save();
            }
            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

            $response = curl_exec($ch);
            $result = json_decode($response);

            if ($request->ajax()) {
                return response()->json(['message' => 'Notfication Send Success', 'status' => true, 'response' => $response], 200);
            }

            return back()->with('success', "Notfication Send Successfully.");
        } catch (\Exception $exception) {
            if ($request->ajax()) {
                return response()->json(['message' => $exception->getMessage(), 'status' => false], 500);
            }
            return back()->with('error', "Oops! Something Went Wrong.");
        }
    }

    public function markNotification(Request $request)
    {

        auth()->guard('admin')->user()
            ->unreadNotifications
            ->when($request->input('id'), function ($query) use ($request) {
                return $query->where('id', $request->input('id'));
            })
            ->markAsRead();

        return response()->noContent();
    }
}
