<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\FAQ;
use Illuminate\Database\QueryException;
use \Yajra\Datatables\Datatables;

class FAQController extends Controller
{
    public function saveFAQ(Request $request)
    {

        $request->validate([
            'question' => 'required',
            'answer' => 'required'
        ]);

        try {
            $faq = new FAQ();
            $faq->question = $request->question;
            $faq->answer = $request->answer;
            $res =  $faq->save();
            if ($res == 1) {

                return back()->with('success', "FAQ Added Successfully");
            } else {
                return back()->with('error', "Something Wrong");
            }
        } catch (QueryException $e) {

            return back()->with('error', $e->getMessage());
        }
    }
    public function updateFAQ(Request $request)
    {

        $request->validate([
            'question' => 'required',
            'answer' => 'required'
        ]);

        try {
            $res = FAQ::where('id', $request->id)
                ->update([
                    'question' => $request->question,
                    'answer' => $request->answer
                ]);

            if ($res == 1) {

                return back()->with('success', "FAQ Updated Successfully");
            } else {
                return back()->with('error', "Something Wrong");
            }
        } catch (QueryException $e) {

            return back()->with('error', $e->getMessage());
        }
    }
    public function getFAQ(Request $request)
    {
        if ($request->ajax()) {
            $data = FAQ::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = ' 
                    <a href="' . route('admin.edit-faq', ['id' => $data->id]) . '"  class="text-muted"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('question', function ($data) {
                    return $data->question;
                })
                ->addColumn('answer', function ($data) {
                    return $data->answer;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteFAQ(Request $request)
    {
        $res = FAQ::where('id', $request->id)->delete();
        return $res;
    }

    public function editFAQ(Request $request)
    {
        $res = FAQ::where('id', $request->id)->first();
        return view('admin.FAQ.edit', ['data' => $res]);
    }
}
