<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ServiceBooking;
use App\Models\User;
use Intervention\Image\Facades\Image;
use Cviebrock\EloquentSluggable\Services\SlugService;
use \Yajra\Datatables\Datatables;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;
use Validator;
use App\Imports\AgentImport;
use Maatwebsite\Excel\Facades\Excel;

class AgentController extends Controller
{

    public function getAgent(Request $request)
    {
        if ($request->ajax()) {
            $data =    User::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '  <a href="' . route('admin.view-agent', ['slug' => $data->slug]) . '"  class="text-muted"> <span class="badge badge-success"><i class="far fa-eye"></i></span></a>
                    <a href="' . route('admin.edit-agent', ['slug' => $data->id]) . '"  class="text-muted"> <span class="badge badge-primary"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('id', function ($data) {
                    return $data->employeeID;
                })
                ->addColumn('name', function ($data) {
                    if ($data->image != NULL) {
                        $img = 'uploads/agent/' . $data->image;
                    } else {
                        $img = 'assets/images/default-image.jpg';
                    }
                    $html = '<a href="' . route('admin.view-agent', ['slug' => $data->slug]) . '" ><div class="dropdown-item profile-sec">
                    <img src="' . asset($img) . '" alt="agent" style="height:35px;">
                    <span style="color:blue;">' . str::limit($data->name, 15) . '</span>
                    
                </div></a>'
                ;
               
                    return  $html;
                })
                ->addColumn('email', function ($data) {
                    return str::limit($data->email, 15);
                })
                ->addColumn('number', function ($data) {
                    $html='<p>' . $data->mobile_number . '</p>';
                      if($data->gpay_name!=NULL){
                $html .=  '<p style="color:blue;">gpay name:' . $data->gpay_name . '</p>';
                }
                if($data->gpay_number!=NULL){
                  $html .=  ' <p style="color:blue;">gpay number:' . $data->gpay_number . '</p>';
                
                }
                    return $html;
                })

                ->addColumn('commission', function ($data) {
                    return  '<span class="badge badge-primary">Rs. ' . $data->total_commission . ' </span>';
                })
                ->addColumn('status', function ($data) {
                    if ($data->status == 1) {
                        $status = 'Active';
                        $class = "success";
                        $val = 0;
                    } else {
                        $status = 'Block';
                        $class = "danger";
                        $val = 1;
                    }
                    return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="status"><span class="badge badge-' . $class . '">' . $status . '</span></a>';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }
    public function editAgent(Request $request)
    {
        $res = User::where('id', $request->slug)->first();
        return view('admin.agent.edit', ['data' => $res]);
    }
    public function viewAgent(Request $request)
    {
        $res = User::where('slug', $request->slug)->first();
        return view('admin.agent.view', ['data' => $res]);
    }

    public function deleteAgent(Request $request)
    {
        $res = User::where('id', $request->id)->delete();
        return $res;
    }

    public function changeAgentStatus(Request $request)
    {

        $res = User::where('id', $request->id)
            ->update(['status' => $request->status]);

        return $res;
    }

    public function checkMailExist(Request $request)
    {
        $res = User::where('email', $request->email)->first();
        if (!empty($res)) {
            $msg = 1;
        } else {
            $msg = 0;
        }
        return $msg;
    }

    public function checkNumberExist(Request $request)
    {
        $res = User::where('mobile_number', $request->number)->first();
        if (!empty($res)) {
            $msg = 1;
        } else {
            $msg = 0;
        }
        return $msg;
    }

    public function saveAgent(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'mobile_number' => 'required|numeric|digits:10|unique:users',
            'designation' => 'required'
            // 'password' => 'required|min:6',
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();
            return redirect()->back()->withErrors($errors);
        }

        $imgname = NULL;
        // ******** Image uploade start ********
        if ($request->hasFile('image')) {
            $image = $request->image;
            $rand = rand(100, 999);
            $input['file'] = time() . $rand . '.' . $image->getClientOriginalExtension();
            $imgname = $input['file'];
            $destinationPath = public_path('uploads/agent');

            $imgFile = Image::make($image->getRealPath());
            $img = Image::make($image)
                // ->resize(870, 400)
                ->save($destinationPath . '/' . $input['file']);
            $img->save();
        }
        // ******** Image uploade end ********
        $rand_pswd = rand(100000, 999999);
        $eid = 'BW' . rand(100000, 999999);
        $pswd = Hash::make($rand_pswd);
        $data = [
            'name' => $request->name,
            'email' => $request->mobile_number,
            'password' => $rand_pswd,
        ];
        $res = User::insert([
            'name' => $request->name,
            'slug' => SlugService::createSlug(User::class, 'slug', $request->name),
            'email' => $request->email,
            'password' => $pswd,
            'mobile_number' => $request->mobile_number,
            'employeeID' => $eid,
            'designation' => $request->designation,
            'image' => $imgname,
              'gpay_number' => $request->gpay_number,
                'gpay_name' => $request->gpay_name,
        ]);

        if ($res == 1) {
            Mail::to($request->email)->send(new \App\Mail\AgentRegisterMail($data));
            return back()->with('success', "Agent Added Successfully and mail send to " . $request->email);
        } else {
            return back()->with('error', "Something Wrong");
        }
    }

    public function updateAgent(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|',
            'mobile_number' => 'required|numeric|digits:10',
            'designation' => 'required'
            // 'password' => 'required|min:6',
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();
            return redirect()->back()->withErrors($errors);
        }


        // ******** Image uploade start ********
        if ($request->hasFile('image')) {
            $image = $request->image;
            $rand = rand(100, 999);
            $input['file'] = time() . $rand . '.' . $image->getClientOriginalExtension();
            $imgname = $input['file'];
            $destinationPath = public_path('uploads/agent');

            $imgFile = Image::make($image->getRealPath());
            $res = User::where('id', $request->id)
                ->update([
                    'image' => $input['file']
                ]);
            $img = Image::make($image)
                // ->resize(870, 400)
                ->save($destinationPath . '/' . $input['file']);
            $img->save();
        }
        // ******** Image uploade end ********
        $data = User::where('id', $request->id)->first();
        if ($request->name != $data->name) {
            $slug = SlugService::createSlug(User::class, 'slug', $request->name);
        } else {
            $slug = $data->slug;
        }
        $res = User::where('id', $request->id)
            ->update([
                'name' => $request->name,
                'slug' => $slug,
                'email' => $request->email,
                'mobile_number' => $request->mobile_number,
                'designation' => $request->designation,
                  'gpay_number' => $request->gpay_number,
                'gpay_name' => $request->gpay_name,
            ]);

        if ($res == 1) {

            return redirect()->route('admin.edit-agent', ['slug' => $slug])->with('success', "Agent Details updated successfully");
        } else {
            return back()->with('error', "Something Wrong");
        }
    }

    public function updateAgentID(Request $request)
    {
        $data = User::get();
        foreach ($data as $item) {
            if ($item->employeeID == '') {
                $eid = 'BW' . rand(100000, 999999);
                $res = User::where('id', $item->id)
                    ->update([
                        'employeeID' => $eid
                    ]);
            }
        }
    }
    
  public function importAgent()
    {
        try {
            Excel::import(new AgentImport, request()->file('file'));
        } catch (\Exception $e) {
            return back()->with('error', $e->getMessage());
        }
        return back();
    }
}
