<?php
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\StadiumController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\EventBlockController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\StadiumBlockController;

Route::get('/', function () {
    return view('auth.login');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Country routes
    Route::get('/country', function () {
        return view('admin.country');
    })->name('country.index');

    // Settings Controller routes
    Route::controller(SettingsController::class)->group(function () {
           Route::get('/get/country', 'getCountry')->name('get-country');
        Route::post('/add/country', 'addCountry')->name('add-country');
        Route::delete('/delete-country/{id}','destroy')->name('delete-country');
        Route::put('/update-country/{id}', 'update')->name('update-country');

          // Country routes

    });


    
     // category routes
    Route::get('/category', function () {
        return view('admin.category');
    })->name('category.index');

    // Settings Controller routes
    Route::controller(CategoryController::class)->group(function () {
           Route::get('/get/category', 'getcategory')->name('get-category');
        Route::post('/add/category', 'addcategory')->name('add-category');
        Route::delete('/delete-category/{id}','destroy')->name('delete-category');
        Route::put('/update-category/{id}', 'update')->name('update-category');     
    });
     // category routes


     // ******** tickets ******
// Teams
Route::get('/teams', [TeamController::class, 'index'])->name('teams');
Route::post('/add-team', [TeamController::class, 'store'])->name('add-team');
Route::get('/get-teams', [TeamController::class, 'getTeams'])->name('get-teams');
Route::put('/update-team/{id}', [TeamController::class, 'update']);
Route::delete('/delete-team/{id}', [TeamController::class, 'destroy']);

// Stadiums
Route::get('/stadiums', [StadiumController::class, 'index'])->name('stadiums');
Route::get('/get-stadiums', [StadiumController::class, 'getStadiums'])->name('get-stadiums');
Route::post('/add-stadium', [StadiumController::class, 'store'])->name('add-stadium');
Route::post('/update-stadium/{id}', [StadiumController::class, 'update'])->name('update-stadium');
Route::delete('/delete-stadium/{id}', [StadiumController::class, 'destroy'])->name('delete-stadium');

//stadium block
Route::get('/stadium-blocks', function(){ return view('admin.stadium_blocks'); })->name('stadium-blocks');
Route::get('/get-blocks', [StadiumBlockController::class, 'getBlocks'])->name('get-blocks');
Route::post('/add-block', [StadiumBlockController::class, 'store'])->name('add-block');
Route::post('/update-block/{id}', [StadiumBlockController::class, 'update'])->name('update-block');
Route::delete('/delete-block/{id}', [StadiumBlockController::class, 'destroy'])->name('delete-block');


// Events
Route::get('/events', fn() => view('admin.events'))->name('events');
Route::get('/get-events', [EventController::class, 'getEvents'])->name('get-events');
Route::post('/add-event', [EventController::class, 'store'])->name('add-event');
Route::post('/update-event/{id}', [EventController::class, 'updateEvent'])->name('update-event');
Route::delete('/delete-event/{id}', [EventController::class, 'destroy'])->name('delete-event');
Route::get('/get-event/{id}', [EventController::class, 'editEvent'])->name('edit-event');

//event block
Route::get('/event-blocks', [EventBlockController::class, 'index'])->name('event-blocks');
Route::get('/get-event-blocks', [EventBlockController::class, 'getBlocks'])->name('get-event-blocks');
Route::post('/add-event-block', [EventBlockController::class, 'store'])->name('add-event-block');
Route::get('/get-event-block/{id}', [EventBlockController::class, 'edit'])->name('get-event-block');
Route::post('/update-event-block/{id}', [EventBlockController::class, 'update'])->name('update-event-block');
Route::delete('/delete-event-block/{id}', [EventBlockController::class, 'destroy'])->name('delete-event-block');
     // ***********tickets ends ***********
});

require __DIR__.'/auth.php';
