<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('events', function (Blueprint $table) {
             $table->id();
            $table->string('name'); // e.g., "AUS vs ARG - Group Stage"
            $table->enum('type', ['cricket', 'football', 'concert', 'other'])->default('cricket');
            $table->foreignId('stadium_id')->nullable()->constrained('stadiums')->onDelete('set null');
            $table->foreignId('team_a_id')->nullable()->constrained('teams')->onDelete('set null');
            $table->foreignId('team_b_id')->nullable()->constrained('teams')->onDelete('set null');
            $table->dateTime('start_time');
            $table->dateTime('end_time')->nullable();
            $table->string('status')->default('scheduled'); // scheduled, live, completed
            $table->string('match_format')->nullable(); // T20, ODI, Test, etc.
            $table->string('banner_image')->nullable();
            $table->text('description')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('events');
    }
};
