
<?php $__env->startSection('title', 'Sub Category'); ?>
<?php $__env->startSection('content'); ?>

<div class="page-content">
    <div class="container-xxl">

        <!-- Add Form -->
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between">
                <h5>Add Sub Category</h5>
            </div>
            <div class="card-body">
                <form id="addSubCategoryForm" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">Main Category</label>
                            <select name="category_id" class="form-control" required>
                                <option value="">Select Category</option>
                                <?php $__currentLoopData = App\Models\Category::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Sub Category Name</label>
                            <input type="text" name="name" class="form-control" placeholder="Enter subcategory name" required>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Image</label>
                            <input type="file" name="photo" class="form-control">
                        </div>
                    </div>
                    <div class="text-end mt-3">
                        <button type="submit" class="btn btn-success">Save</button>
                    </div>
                </form>
            </div>
        </div>

        <!-- DataTable -->
        <div class="card">
            <div class="card-body table-responsive">
                <table class="table table-bordered align-middle text-center">
                    <thead class="table-light">
                        <tr>
                            <th>SL.NO</th>
                            <th>Sub Category</th>
                            <th>Main Category</th>
                            <th>Image</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editSubCatModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="editSubCategoryForm" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5>Edit Sub Category</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" id="edit_id">
                    <div class="mb-3">
                        <label>Main Category</label>
                        <select name="category_id" id="edit_category" class="form-control">
                            <?php $__currentLoopData = App\Models\Category::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label>Name</label>
                        <input type="text" name="name" id="edit_name" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label>Image</label>
                        <input type="file" name="photo" class="form-control">
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" type="submit">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(function(){
    var table = $('.table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo e(route('get-subcategory')); ?>",
        columns: [
            {data:'DT_RowIndex', name:'DT_RowIndex'},
            {data:'name', name:'name'},
            {data:'category', name:'category'},
            {data:'image', name:'image'},
            {data:'status', name:'status'},
            {data:'action', name:'action'},
        ],
    });

    // Add
    $('#addSubCategoryForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url:"<?php echo e(route('add-subcategory')); ?>",
            method:"POST",
            data:new FormData(this),
            processData:false,
            contentType:false,
            success:function(res){
                Swal.fire({icon:'success',title:res.success,showConfirmButton:false,timer:1500});
                $('#addSubCategoryForm')[0].reset();
                table.ajax.reload();
            }
        });
    });

    // Edit open
    $(document).on('click','.editSubCategory', function(){
        $('#edit_id').val($(this).data('id'));
        $('#edit_name').val($(this).data('name'));
        $('#edit_category').val($(this).data('category'));
        $('#editSubCatModal').modal('show');
    });

    // Update
    $('#editSubCategoryForm').on('submit', function(e){
        e.preventDefault();
        var id = $('#edit_id').val();
        $.ajax({
            url:'/update-subcategory/'+id,
            method:'POST',
            data:new FormData(this),
            processData:false,
            contentType:false,
            success:function(res){
                Swal.fire({icon:'success',title:res.success,showConfirmButton:false,timer:1500});
                $('#editSubCatModal').modal('hide');
                table.ajax.reload();
            }
        });
    });

    // Delete
    $(document).on('click','.deleteSubCategory', function(){
        var id=$(this).data('id');
        Swal.fire({
            title:'Are you sure?',text:'You will not be able to revert this!',icon:'warning',
            showCancelButton:true,confirmButtonColor:'#3085d6',cancelButtonColor:'#d33',
            confirmButtonText:'Yes, delete it!'
        }).then((result)=>{
            if(result.isConfirmed){
                $.ajax({
                    url:'/delete-subcategory/'+id,
                    method:'DELETE',
                    data:{_token:'<?php echo e(csrf_token()); ?>'},
                    success:function(res){
                        Swal.fire({icon:'success',title:res.success,showConfirmButton:false,timer:1500});
                        table.ajax.reload();
                    }
                });
            }
        });
    });

    // Status Toggle
    $(document).on('change','.toggleStatus',function(){
        var id=$(this).data('id');
        $.ajax({
            url:'/toggle-subcategory-status/'+id,
            method:'POST',
            data:{_token:'<?php echo e(csrf_token()); ?>'},
            success:function(res){
                toastr.success(res.success);
            }
        });
    });
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.template', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tappy\resources\views/admin/subcategory.blade.php ENDPATH**/ ?>