@extends('admin.layout.template')
@section('title', 'Manage Event Blocks')
@section('content')
<div class="page-content">
    <div class="container-xxl">

        <!-- Add Event Block -->
        <div class="card">
            <div class="card-header"><h4 class="card-title">Add Event Block</h4></div>
            <div class="card-body">
                <form id="addBlockForm">
                    @csrf
                    <div class="row">
                        <div class="col-lg-4 mb-3">
                            <label class="form-label">Event</label>
                            <select name="event_id" class="form-select" required>
                                <option value="">-- Select Event --</option>
                                @foreach(App\Models\Event::all() as $e)
                                    <option value="{{ $e->id }}">{{ $e->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-lg-4 mb-3">
                            <label class="form-label">Stadium Block</label>
                            <select name="stadium_block_id" class="form-select" required>
                                <option value="">-- Select Block --</option>
                                @foreach(App\Models\StadiumBlock::all() as $s)
                                    <option value="{{ $s->id }}">{{ $s->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-lg-4 mb-3">
                            <label class="form-label">Total Tickets</label>
                            <input type="number" name="total_tickets" class="form-control" required>
                        </div>

                        <div class="col-lg-4 mb-3">
                            <label class="form-label">Tickets Sold</label>
                            <input type="number" name="tickets_sold" class="form-control" value="0">
                        </div>

                        <div class="col-lg-4 mb-3">
                            <label class="form-label">Price</label>
                            <input type="number" step="0.01" name="price" class="form-control" required>
                        </div>

                        <div class="col-lg-4 mb-3">
                            <label class="form-label">Status</label>
                            <select name="status" class="form-select">
                                <option value="available">Available</option>
                                <option value="sold_out">Sold Out</option>
                            </select>
                        </div>
                    </div>
                    <div class="text-end">
                        <button type="submit" class="btn btn-success">Save Block</button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Event Blocks Table -->
        <div class="card mt-4">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover table-centered align-middle">
                        <thead class="bg-light-subtle">
                            <tr>
                                <th>#</th>
                                <th>Event</th>
                                <th>Stadium Block</th>
                                <th>Total Tickets</th>
                                <th>Tickets Sold</th>
                                <th>Price</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Edit Block Modal -->
<div class="modal fade" id="editBlockModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Edit Event Block</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="editBlockForm">
          @csrf
          <input type="hidden" id="edit_block_id">

          <div class="row">
              <div class="col-lg-6 mb-3">
                  <label class="form-label">Event</label>
                  <select id="edit_event_id" name="event_id" class="form-select" required>
                      @foreach(App\Models\Event::all() as $e)
                          <option value="{{ $e->id }}">{{ $e->name }}</option>
                      @endforeach
                  </select>
              </div>
              <div class="col-lg-6 mb-3">
                  <label class="form-label">Stadium Block</label>
                  <select id="edit_stadium_block_id" name="stadium_block_id" class="form-select" required>
                      @foreach(App\Models\StadiumBlock::all() as $s)
                          <option value="{{ $s->id }}">{{ $s->name }}</option>
                      @endforeach
                  </select>
              </div>
              <div class="col-lg-6 mb-3">
                  <label class="form-label">Total Tickets</label>
                  <input type="number" id="edit_total_tickets" name="total_tickets" class="form-control" required>
              </div>
              <div class="col-lg-6 mb-3">
                  <label class="form-label">Tickets Sold</label>
                  <input type="number" id="edit_tickets_sold" name="tickets_sold" class="form-control">
              </div>
              <div class="col-lg-6 mb-3">
                  <label class="form-label">Price</label>
                  <input type="number" step="0.01" id="edit_price" name="price" class="form-control" required>
              </div>
              <div class="col-lg-6 mb-3">
                  <label class="form-label">Status</label>
                  <select id="edit_status" name="status" class="form-select">
                      <option value="available">Available</option>
                      <option value="sold_out">Sold Out</option>
                  </select>
              </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          <button type="button" class="btn btn-success" id="saveBlockChanges">Update</button>
      </div>
    </div>
  </div>
</div>

<script>
$(function(){
    var table = $('.table').DataTable({
        processing:true,
        serverSide:true,
        ajax:"{{ route('get-event-blocks') }}",
        columns:[
            {data:'DT_RowIndex', name:'DT_RowIndex', orderable:false, searchable:false},
            {data:'event_name', name:'event_name'},
            {data:'block_name', name:'block_name'},
            {data:'total_tickets', name:'total_tickets'},
            {data:'tickets_sold', name:'tickets_sold'},
            {data:'price', name:'price'},
            {data:'status', name:'status'},
            {data:'action', name:'action', orderable:false, searchable:false},
        ]
    });

    // ADD
    $('#addBlockForm').submit(function(e){
        e.preventDefault();
        $.ajax({
            url:"{{ route('add-event-block') }}",
            type:"POST",
            data:$(this).serialize(),
            success:function(res){
                Swal.fire({icon:'success', title:'Added!', text:res.success, timer:1500});
                $('#addBlockForm')[0].reset();
                table.ajax.reload();
            },
            error:function(xhr){
                Swal.fire({icon:'error', title:'Error', text:Object.values(xhr.responseJSON.errors).join("\\n")});
            }
        });
    });

    // EDIT
    $(document).on('click','.editBlock',function(){
        var id=$(this).data('id');
        $.get("/get-event-block/"+id,function(res){
            var b=res.block;
            $('#edit_block_id').val(b.id);
            $('#edit_event_id').val(b.event_id);
            $('#edit_stadium_block_id').val(b.stadium_block_id);
            $('#edit_total_tickets').val(b.total_tickets);
            $('#edit_tickets_sold').val(b.tickets_sold);
            $('#edit_price').val(b.price);
            $('#edit_status').val(b.status);
            $('#editBlockModal').modal('show');
        });
    });

    // UPDATE
    $('#saveBlockChanges').click(function(){
        var id=$('#edit_block_id').val();
        $.ajax({
            url:"/update-event-block/"+id,
            method:"POST",
            data:$('#editBlockForm').serialize(),
            success:function(res){
                Swal.fire({icon:'success', title:'Updated!', text:res.success, timer:1500});
                $('#editBlockModal').modal('hide');
                table.ajax.reload();
            },
            error:function(xhr){
                Swal.fire({icon:'error', title:'Error', text:Object.values(xhr.responseJSON.errors).join("\\n")});
            }
        });
    });

    // DELETE
    $(document).on('click','.deleteBlock',function(){
        var id=$(this).data('id');
        Swal.fire({title:'Are you sure?', text:'This will delete the block!', icon:'warning', showCancelButton:true})
        .then(res=>{
            if(res.isConfirmed){
                $.ajax({
                    url:"/delete-event-block/"+id,
                    method:"DELETE",
                    data:{_token:'{{ csrf_token() }}'},
                    success:function(res){
                        Swal.fire({icon:'success', title:'Deleted!', timer:1500});
                        table.ajax.reload();
                    }
                });
            }
        });
    });
});
</script>
@endsection
