<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Products extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'sub_category_id',
        'country_id',
        'name',
        'slug',
        'description',
        'price',
        'discount_price',
        'stock',
        'status',
    ];

    public function images()
    {
        // ✅ correct relationship
        return $this->hasMany(ProductImage::class, 'product_id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function subCategory()
    {
        return $this->belongsTo(SubCategory::class);
    }

       public function country()
    {
        return $this->belongsTo(Country::class);
    }
}
