<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Banner extends Model
{
   protected $fillable = [
        'title',
        'image',
        'category_id',
        'product_id',       
        'status',
    ];

    
    // ✅ Relationship to Category
    public function category()
    {
        return $this->belongsTo(\App\Models\Category::class);
    }

    // ✅ Relationship to Product
    public function product()
    {
        return $this->belongsTo(\App\Models\Products::class);
    }
}
