<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Team;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\File;
class TeamController extends Controller
{
    public function index()
    {
        return view('admin.teams');
    }

    public function getTeams(Request $request)
    {
        if ($request->ajax()) {
            $data = Team::select('id', 'name', 'short_name', 'flag');
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('flag', function ($row) {
                    return $row->flag;
                    return $row->flag ? '<img src="'.asset($row->flag).'" class="avatar-md">' : '-';
                })
                ->addColumn('action', function ($row) {
                    return '
                    <button class="btn btn-sm btn-primary editTeam" data-id="'.$row->id.'">Edit</button>
                    <button class="btn btn-sm btn-danger deleteTeam" data-id="'.$row->id.'">Delete</button>';
                })
                ->rawColumns(['flag', 'action'])
                ->make(true);
        }
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'short_name' => 'nullable|max:10',
            'flag' => 'nullable|image|max:2048'
        ]);
          if ($request->hasFile('photo')) {
            $image = $request->photo;
            $imageName = time() . '-' . rand(100,999) . '.' . $image->extension();

            $uploadPath = public_path('assets/upload/team/');
            
            // Create folder if not exists
            if (!File::exists($uploadPath)) {
                File::makeDirectory($uploadPath, 0755, true);
            }

            // Move uploaded file
            $image->move($uploadPath, $imageName);

            // Save relative path to DB
            $imagePath = 'assets/upload/team/' . $imageName;
        }

      

        Team::create([
            'name' => ucfirst($request->name),
            'short_name' => $request->short_name,
            'flag' => $imagePath
        ]);

        return back()->with('success', 'Team added successfully!');
    }

   
    public function update(Request $request, $id)
{
    $team = Team::findOrFail($id);

    $request->validate([
        'name'        => 'required|string|max:255',
        'short_name'  => 'required|string|max:50',
    ]);

    $imagePath = $team->flag; // keep existing image if no new one uploaded

    // Handle new file upload (file input name = 'photo')
    if ($request->hasFile('photo')) {
        $image = $request->photo;
        $imageName = time() . '-' . rand(100, 999) . '.' . $image->extension();
        $uploadPath = public_path('assets/upload/team/');

        // Create directory if missing
        if (!File::exists($uploadPath)) {
            File::makeDirectory($uploadPath, 0755, true);
        }

        // Delete old image if it exists
        if ($team->flag && File::exists(public_path($team->flag))) {
            File::delete(public_path($team->flag));
        }

        // Move new image
        $image->move($uploadPath, $imageName);
        $imagePath = 'assets/upload/team/' . $imageName;
    }

    // Update team record
    $team->update([
        'name'       => ucfirst($request->name),
        'short_name' => strtoupper($request->short_name),
        'flag'       => $imagePath,
    ]);

    return response()->json(['success' => 'Team updated successfully!']);
}

    public function destroy($id)
    {
         $team = Team::findOrFail($id);
          // Delete old image if it exists
        if ($team->flag && File::exists(public_path($team->flag))) {
            File::delete(public_path($team->flag));
        }
        Team::findOrFail($id)->delete();
        return response()->json(['success' => 'Team deleted successfully!']);
    }
}
