@extends('admin.layout.template')
@section('title', 'Teams')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <!-- Add Team Card -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title d-flex align-items-center gap-1">
                            <iconify-icon icon="solar:trophy-bold-duotone" class="text-primary fs-20"></iconify-icon>
                            Add Team
                        </h4>
                    </div>
                    <div class="card-body">
                        <form id="addTeamForm" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="mb-3">
                                        <label class="form-label">Team Name</label>
                                        <input type="text" name="name" class="form-control" placeholder="Enter team name" required>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="mb-3">
                                        <label class="form-label">Short Name</label>
                                        <input type="text" name="short_name" class="form-control" placeholder="e.g. IND, PAK" required>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="mb-3">
                                        <label class="form-label">Team Flag / Logo</label>
                                        <input type="file" name="photo" class="form-control" accept="image/*">
                                    </div>
                                </div>
                            </div>
                            <div class="text-end">
                                <button type="submit" class="btn btn-success">Save Team</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Teams Table -->
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0 table-hover table-centered">
                                <thead class="bg-light-subtle">
                                    <tr>
                                        <th>SL.NO</th>
                                        <th>Team Name</th>
                                        <th>Short Name</th>
                                        <th>Flag / Logo</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<script>
$(document).ready(function(){

    // Initialize DataTable
    var table = $('.table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('get-teams') }}",
        columns: [
        { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
        { data: 'name', name: 'name' },
        { data: 'short_name', name: 'short_name' },
        {
            data: 'flag',
            name: 'flag',
            render: function(data) {
                return data ? `<img src="${data}" alt="flag" width="40">` : '';
            }
        },
        { data: 'action', name: 'action', orderable: false, searchable: false },
    ]
    });

    // Add Team
    $('#addTeamForm').submit(function(e){
        e.preventDefault();
        var formData = new FormData(this);
        $.ajax({
            url: "{{ route('add-team') }}",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function(response){
                Swal.fire({
                    icon: 'success',
                    title: 'Team Added!',
                    text: response.success,
                    timer: 1500,
                    showConfirmButton: false
                });
                $('#addTeamForm')[0].reset();
                table.ajax.reload();
            },
            error: function(xhr){
                let errors = xhr.responseJSON.errors;
                let errMsg = '';
                $.each(errors, function(k,v){ errMsg+=v+'\n'; });
                Swal.fire({icon:'error',title:'Oops!',text:errMsg});
            }
        });
    });

    // Delete Team
    $(document).on('click', '.deleteTeam', function(e){
        e.preventDefault();
        var id = $(this).data('id');
        Swal.fire({
            title: 'Are you sure?',
            text: "This will remove the team record!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if(result.isConfirmed){
                $.ajax({
                    url: "{{ url('/delete-team') }}/" + id,
                    type: 'DELETE',
                    data: {_token: '{{ csrf_token() }}'},
                    success: function(response){
                        Swal.fire({
                            icon:'success',
                            title:'Deleted!',
                            text:response.success,
                            timer:1500,
                            showConfirmButton:false
                        });
                        table.ajax.reload();
                    }
                });
            }
        });
    });

    // Inline Edit
    $(document).on('click', '.editTeam', function(e){
        e.preventDefault();
        var row = $(this).closest('tr');
        var id = $(this).data('id');
        var name = row.find('td:eq(1)').text();
        var shortName = row.find('td:eq(2)').text();
        var imgSrc = row.find('td:eq(3) img').attr('src') || '';

        // Replace cells with editable inputs
        row.find('td:eq(1)').html('<input type="text" class="form-control form-control-sm" value="'+name+'">');
        row.find('td:eq(2)').html('<input type="text" class="form-control form-control-sm" value="'+shortName+'">');
        row.find('td:eq(3)').html('<input type="file" class="form-control form-control-sm" name="photo"><br>'+(imgSrc ? `<img src="${imgSrc}" height="40" style="margin-top:5px;">` : ''));

        // Replace action buttons
        $(this).replaceWith('<button class="btn btn-sm btn-success saveTeam" data-id="'+id+'">Save</button> <button class="btn btn-sm btn-secondary cancelEdit">Cancel</button>');
    });

    // Cancel Inline Edit
    $(document).on('click', '.cancelEdit', function(){
        table.ajax.reload();
    });

    // Save Inline Edit
    $(document).on('click', '.saveTeam', function(){
        var id = $(this).data('id');
        var row = $(this).closest('tr');
        var name = row.find('td:eq(1) input').val();
        var shortName = row.find('td:eq(2) input').val();
        var flagFile = row.find('td:eq(3) input[type=file]')[0].files[0];

        var formData = new FormData();
        formData.append('_token', '{{ csrf_token() }}');
        formData.append('_method', 'PUT');
        formData.append('name', name);
        formData.append('short_name', shortName);
        if(flagFile) formData.append('photo', flagFile);

        $.ajax({
            url: "{{ url('/update-team') }}/"+id,
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function(response){
                Swal.fire({
                    icon:'success',
                    title:'Updated!',
                    text:response.success,
                    timer:1500,
                    showConfirmButton:false
                });
                table.ajax.reload();
            },
            error: function(xhr){
                let errors = xhr.responseJSON.errors;
                let errMsg = '';
                $.each(errors,function(k,v){ errMsg+=v+'\n'; });
                Swal.fire({icon:'error',title:'Oops!',text:errMsg});
            }
        });
    });

});
</script>

@endsection
