@extends('admin.layout.template')
@section('title', 'Products')
@section('content')

<div class="page-content">
  <div class="container-xxl">

    <!-- Add Product Card -->
    <div class="row">
      <div class="col-lg-12">
        <div class="card d-flex">
          <div class="card-header d-flex justify-content-between align-items-center gap-1">
            <h4 class="card-title flex-grow-1">
             <iconify-icon icon="solar:box-bold-duotone" class="text-primary fs-20"></iconify-icon>  
            All Product List</h4>

            <a href="{{route('add-product')}}" class="btn btn-sm btn-purple">
              Add Product
            </a>


          </div>
      
        </div>
      </div>
    </div>

    <!-- Edit Product Modal -->
    <div class="modal fade" id="editProductModal" tabindex="-1" aria-labelledby="editProductModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header bg-primary text-white">
            <h5 class="modal-title" id="editProductModalLabel">Edit Product</h5>
            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <form id="editProductForm" enctype="multipart/form-data">
              @csrf
              <input type="hidden" name="id" id="edit_id">

              <div class="row g-3">
                <div class="col-lg-4">
                  <label class="form-label">Category</label>
                  <select name="category_id" id="edit_category" class="form-control" required>
                    <option value="">Select Category</option>
                    @foreach(App\Models\Category::all() as $cat)
                    <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                    @endforeach
                  </select>
                </div>

                <div class="col-lg-4">
                  <label class="form-label">Subcategory</label>
                  <select name="sub_category_id" id="edit_subcategory" class="form-control">
                    <option value="">Select Subcategory</option>
                  </select>
                </div>

                <div class="col-lg-4">
                  <label class="form-label">Product Name</label>
                  <input type="text" name="name" id="edit_name" class="form-control" required>
                </div>

                <div class="col-lg-4">
                  <label class="form-label">Price</label>
                  <input type="number" name="price" id="edit_price" class="form-control" required>
                </div>

                <div class="col-lg-4">
                  <label class="form-label">Discount Price</label>
                  <input type="number" name="discount_price" id="edit_discount_price" class="form-control">
                </div>
                <div class="col-lg-4">
                  <div class="mb-3">
                    <label class="form-label">Country</label>
                    <select class="form-control" name="country_id" id="country_id" required>
                      @foreach(App\Models\Country::get() as $item)
                      <option value="{{$item->id}}">{{$item->name}}</option>
                      @endforeach
                    </select>
                  </div>
                </div>


                <div class="col-lg-12">
                  <label class="form-label">Description</label>
                  <textarea name="description" id="edit_description" class="form-control" rows="3"></textarea>
                </div>

                <div class="col-lg-4">
                  <label class="form-label">Images (Optional)</label>
                  <input type="file" name="images[]" class="form-control" multiple>
                  <div id="existingImages" class="mt-2 d-flex flex-wrap gap-2"></div>
                </div>
                <div class="col-lg-4">
                  <label class="form-label">Stock</label>
                  <input type="number" name="stock" id="edit_stock" class="form-control">
                </div>
                <div class="col-lg-4">
                  <label class="form-label">Status</label>
                  <select name="status" id="edit_status" class="form-control">
                    <option value="1">Active</option>
                    <option value="0">Inactive</option>
                  </select>
                </div>
              </div>

              <div class="text-end mt-3">
                <button type="submit" class="btn btn-primary">Update Product</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>

    <!-- Product Table -->
    <div class="row mt-3">
      <div class="col-xl-12">
        <div class="card">
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table align-middle mb-0 table-hover table-centered">
                <thead class="bg-light-subtle">
                  <tr>
                    <th>SL.NO</th>
                    <th>Product</th>
                    <th>Category</th>
                    <th>Subcategory</th>
                    <th>Country</th>
                    <th>Images</th>
                    <th>Price</th>
                    <th>Stock</th>
                    <th>Status</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>


<!-- ========================== JAVASCRIPT ========================== -->
<script>
  $(document).ready(function() {
    // Initialize DataTable
    var table = $('.table').DataTable({
      processing: true,
      serverSide: true,
      ajax: "{{ route('get-products') }}",
      // order: [
      //   [1, 'asc']
      // ],
      columns: [{
          data: 'DT_RowIndex',
          name: 'DT_RowIndex',
          orderable: false,
          searchable: false
        },
        {
          data: 'name',
          name: 'name'
        },
        {
          data: 'category',
          name: 'category'
        },
        {
          data: 'subcategory',
          name: 'subcategory'
        },
        {
          data: 'country',
          name: 'country'
        },
        {
          data: 'images',
          name: 'images',
          orderable: false,
          searchable: false
        },
        {
          data: 'price',
          name: 'price'
        },
        {
          data: 'stock',
          name: 'stock'
        },
        {
          data: 'status',
          name: 'status',
          orderable: false
        },
        {
          data: 'action',
          name: 'action',
          orderable: false,
          searchable: false
        }
      ]
    });



    // Delete Product
    $(document).on('click', '.deleteProduct', function() {
      var id = $(this).data('id');
      Swal.fire({
        title: 'Delete Product?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, delete',
        cancelButtonText: 'Cancel'
      }).then(result => {
        if (result.isConfirmed) {
          $.ajax({
            url: "{{ url('delete-product') }}/" + id,
            type: 'DELETE',
            data: {
              _token: '{{ csrf_token() }}'
            },
            success: function(res) {
              Swal.fire({
                icon: 'success',
                title: 'Deleted!',
                text: res.success,
                timer: 1500,
                showConfirmButton: false
              });
              table.ajax.reload();
            }
          });
        }
      });
    });


  });

  $(document).on('click', '.toggleTrending', function() {
    let productId = $(this).data('id');
    let button = $(this);

    Swal.fire({
      title: 'Are you sure?',
      text: 'You want to change the trending status for this product?',
      icon: 'question',
      showCancelButton: true,
      confirmButtonColor: '#6f42c1',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, update it'
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: `/product-trending/${productId}`,
          type: 'POST',
          data: {
            _token: '{{ csrf_token() }}'
          },
          success: function(response) {
            if (response.success) {
              Swal.fire({
                icon: 'success',
                title: 'Updated!',
                text: response.message,
                timer: 1200,
                showConfirmButton: false
              });

              // ✅ Update color & text immediately
              if (response.is_trending == 1 || response.is_trending === true) {
                button.removeClass('btn-secondary')
                  .addClass('btn-purple')
                  .html('<i class="bx bxs-star"></i> Trending');
              } else {
                button.removeClass('btn-purple')
                  .addClass('btn-secondary')
                  .html('Set Trending');
              }

              // ✅ Optional: refresh the table row (not full reload)
              if (typeof table !== 'undefined') {
                table.ajax.reload(null, false);
              }
            }
          },
          error: function() {
            Swal.fire('Error!', 'Something went wrong.', 'error');
          }
        });
      }
    });
  });
</script>

@endsection