<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice #{{ $order->order_number }}</title>

    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 13px;
            color: #333;
            margin: 0;
        }

        /* HEADER */
        .header {
            background: #6A3FA0;
            color: #fff;
            padding: 25px;
        }

        .header-table {
            width: 100%;
        }

        .header-table td {
            vertical-align: middle;
        }

        .logo {
            height: 50px;
        }

        .invoice-title {
            font-size: 26px;
            font-weight: bold;
            text-align: right;
        }

        /* CONTENT */
        .content {
            padding: 25px;
        }

        .company-details,
        .invoice-details {
            font-size: 12px;
        }

        .invoice-details {
            text-align: right;
        }

        .section {
            margin-top: 25px;
        }

        /* TABLE */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        th {
            background: #F3EDF9;
            color: #333;
            padding: 10px;
            border: 1px solid #ddd;
            font-size: 12px;
        }

        td {
            padding: 10px;
            border: 1px solid #ddd;
            font-size: 12px;
        }

        .text-right {
            text-align: right;
        }

        /* SUMMARY */
        .summary-table {
            width: 100%;
            margin-top: 20px;
        }

        .summary-table td {
            padding: 8px;
            border: none;
            font-size: 13px;
        }

        .total-box {
            background: #6A3FA0;
            color: #fff;
            padding: 15px;
            font-size: 20px;
            font-weight: bold;
            text-align: right;
        }

        /* NOTES */
        .notes {
            background: #F3EDF9;
            padding: 15px;
            font-size: 12px;
            margin-top: 20px;
        }

        /* FOOTER */
        .footer {
            text-align: center;
            font-size: 11px;
            color: #777;
            margin-top: 30px;
        }
    </style>
</head>
<body>

{{-- HEADER --}}
<div class="header">
    <table class="header-table">
        <tr>
            <td>
                <img src="https://demoweblinks.in/tappy-app/public/assets/images/invoice-logo.png" class="logo">
            </td>
            <td class="invoice-title">
                INVOICE
            </td>
        </tr>
    </table>
</div>

{{-- CONTENT --}}
<div class="content">

    <table width="100%">
        <tr>
            <td class="company-details">
                <strong>Tappygifts</strong><br>
                Address Line 1<br>
                City, Country<br>
                Phone: +91 XXXXXXXX
            </td>
            <td class="invoice-details">
                <strong>Invoice #:</strong> {{ $order->order_number }}<br>
                <strong>Date:</strong> {{ $order->created_at->format('d M Y') }}
            </td>
        </tr>
    </table>

    {{-- BILL TO --}}
    <div class="section">
        <strong>Bill To:</strong><br>
        {{ $order->user->name }}<br>
        {{ $order->user->email }}<br>
        {{ $order->shipping_address }}
    </div>

    {{-- ITEMS --}}
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Product</th>
                <th>Qty</th>
                <th class="text-right">Price</th>
                <th class="text-right">Tax</th>
                <th class="text-right">Amount</th>
            </tr>
        </thead>
        <tbody>
            @foreach($order->items as $i => $item)
            <tr>
                <td>{{ $i + 1 }}</td>
                <td>{{ $item->product->name }}</td>
                <td>{{ $item->qty }}</td>
                <td class="text-right">₹{{ number_format($item->price, 2) }}</td>
                <td class="text-right">₹{{ number_format($item->tax, 2) }}</td>
                <td class="text-right">₹{{ number_format($item->total, 2) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    {{-- SUMMARY --}}
    <table class="summary-table">
        <tr>
            <td class="text-right">Subtotal:</td>
            <td class="text-right">₹{{ number_format($order->subtotal,2) }}</td>
        </tr>
        <tr>
            <td class="text-right">Discount:</td>
            <td class="text-right">-₹{{ number_format($order->discount,2) }}</td>
        </tr>
        <tr>
            <td class="text-right">Tax:</td>
            <td class="text-right">₹{{ number_format($order->tax,2) }}</td>
        </tr>
    </table>

    <div class="total-box">
        TOTAL : ₹{{ number_format($order->total,2) }}
    </div>

    {{-- NOTES --}}
    <div class="notes">
        <strong>Notes:</strong><br>
        Thank you for shopping with Tappygifts 💜
    </div>

    <div class="footer">
        This is a system generated invoice.
    </div>

</div>

</body>
</html>
