@extends('admin.layout.template')
@section('title', 'Banner')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <!-- Add Banner -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Add Banner</h4>
                    </div>
                    <div class="card-body">
                        <form id="addBannerForm" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-3 mb-3">
                                    <label class="form-label">Title</label>
                                    <input type="text" name="title" class="form-control" placeholder="Enter banner title">
                                </div>
                                <div class="col-lg-3">
                                    <label class="form-label">Category</label>
                                    <select name="category_id" id="category_id" class="form-control">
                                        <option value="">-- Select Category --</option>
                                        @foreach(App\Models\Category::all() as $cat)
                                        <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-lg-3">
                                    <label class="form-label">Product</label>
                                    <select name="product_id" id="product_id" class="form-control">
                                        <option value="">-- Select Product --</option>
                                    </select>
                                </div>
                                <div class="col-lg-3">
                                    <label class="form-label">Image</label>
                                    <input type="file" name="image" class="form-control" required>
                                </div>
                                <div class="col-lg-4">
                                    <label>Set as Seasonal Banner</label>
                                    <div class="form-check form-switch">
                                        <input type="hidden" name="seasonal_banner" value="0">
                                        <input class="form-check-input" value="1" name="seasonal_banner" type="checkbox" id="seasonal">

                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <label>Start Date</label>
                                    <input type="date" name="start_date" class="form-control" id="start_date" disabled>
                                </div>
                                <div class="col-lg-4">
                                    <label>End Date</label>
                                    <input type="date" name="end_date" class="form-control" id="end_date" disabled>
                                </div>
                            </div>
                            <div class="text-end mt-3">
                                <button type="submit" class="btn btn-success">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Banner Table -->
        <div class="row mt-4">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle table-hover table-centered">
                                <thead class="bg-light-subtle">
                                    <tr>
                                        <th>SL.NO</th>
                                        <th>Title</th>
                                        <th>Category</th>
                                        <th>Product</th>
                                        <th>Image</th>
                                        <th>Status</th>
                                        <th>Season Banner?</th>
                                        <th>Start Date</th>
                                        <th>End Date</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- 🔥 Edit Modal -->
<div class="modal fade" id="editBannerModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="editBannerForm" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="banner_id" id="edit_banner_id">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Banner</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-3 mb-3">
                            <label>Title</label>
                            <input type="text" name="title" id="edit_title" class="form-control">
                        </div>
                        <div class="col-lg-3">
                            <label>Category</label>
                            <select name="category_id" id="edit_category_id" class="form-control edit-category">
                                @foreach(App\Models\Category::all() as $cat)
                                <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-lg-3">
                            <label>Product</label>
                            <select name="product_id" id="edit_product_id" class="form-control edit-product"></select>
                        </div>
                        <div class="col-lg-3">
                            <label>Image</label>
                            <input type="file" name="image" class="form-control">
                            <img id="current_image" class="mt-2" style="height:60px;">
                        </div>

                        <div class="col-lg-4">
                            <label>Seasonal Banner</label>
                            <div class="form-check form-switch">
                                <input class="form-check-input" name="seasonal_banner" value="1" type="checkbox" id="edit_seasonal">
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <label>Start Date</label>
                            <input type="date" name="start_date" id="edit_start_date" class="form-control">
                        </div>
                        <div class="col-lg-4">
                            <label>End Date</label>
                            <input type="date" name="end_date" id="edit_end_date" class="form-control">
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-purple">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    $(function() {
        var table = $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-banner') }}",
            columns: [{
                    data: 'DT_RowIndex'
                },
                {
                    data: 'title'
                },
                {
                    data: 'category'
                },
                {
                    data: 'product'
                },
                {
                    data: 'image'
                },
                {
                    data: 'status'
                },
                {
                    data: 'seasonal'
                },
                {
                    data: 'start_date'
                },
                {
                    data: 'end_date'
                },
                {
                    data: 'action'
                }
            ]
        });

        // ADD BANNER
        $('#addBannerForm').submit(function(e) {
            e.preventDefault();
            var formData = new FormData(this);
            $.ajax({
                url: "{{ route('add-banner') }}",
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function(res) {
                    Swal.fire('Success', res.success, 'success');
                    $('#addBannerForm')[0].reset();
                    table.ajax.reload();
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    let errMsg = '';
                    $.each(errors, function(k, v) {
                        errMsg += `• ${v}<br>`;
                        //errMsg += v + '\n';
                    });
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: errMsg
                    });
                }
            });
        });

        // OPEN MODAL FOR EDIT
        $(document).on('click', '.editbanner', function() {
            var banner = $(this).data();
            $('#edit_banner_id').val(banner.id);
            $('#edit_title').val(banner.title);
            $('#edit_category_id').val(banner.category_id).trigger('change');
            $('#edit_seasonal').prop('checked', banner.seasonal_banner == 1);
            $('#edit_start_date').val(banner.start_date);
            $('#edit_end_date').val(banner.end_date);
            $('#current_image').attr('src', banner.image);
            $('#editBannerModal').modal('show');

            // Fetch products
            $.get('/get-products/' + banner.category_id, function(data) {
                $('#edit_product_id').empty();
                $.each(data, function(i, p) {
                    $('#edit_product_id').append('<option value="' + p.id + '">' + p.name + '</option>');
                });
                $('#edit_product_id').val(banner.product_id);
            });
        });

        // UPDATE BANNER
        $('#editBannerForm').submit(function(e) {
            e.preventDefault();
            var id = $('#edit_banner_id').val();
            var formData = new FormData(this);
            formData.append('_method', 'PUT');

            $.ajax({
                url: "/update-banner/" + id,
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function(res) {
                    Swal.fire('Updated!', res.success, 'success');
                    $('#editBannerModal').modal('hide');
                    table.ajax.reload();
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    let errMsg = '';
                    $.each(errors, function(k, v) {
                        errMsg += `• ${v}<br>`;
                        //errMsg += v + '\n';
                    });
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: errMsg
                    });
                }
            });
        });

        // STATUS TOGGLE
        $(document).on('click', '.toggleStatusBtn', function() {
            var bannerId = $(this).data('id');
            var btn = $(this);
            $.post("banner/status/" + bannerId, {
                _token: '{{csrf_token()}}'
            }, function(res) {
                btn.toggleClass('btn-success btn-danger').text(res.status ? 'Active' : 'Inactive');
            });
        });

        // PRODUCT CHANGE IN ADD
        $(document).on('change', '#category_id', function() {
            $.get("/get-products/" + $(this).val(), function(data) {
                $('#product_id').html('<option value="">-- Select --</option>');
                $.each(data, function(i, p) {
                    $('#product_id').append('<option value="' + p.id + '">' + p.name + '</option>');
                });
            })
        });

        // SEASONAL TOGGLE
        $('#seasonal').change(function() {
            $('#start_date, #end_date').prop('disabled', !$(this).is(':checked'));
        });
        $('#edit_seasonal').change(function() {
            $('#edit_start_date, #edit_end_date').prop('disabled', !$(this).is(':checked'));
        });

        
// 🔄 Load products dynamically when category changes inside edit row
       // 🔄 Load products dynamically in edit modal
$(document).on('change', '.edit-category', function() {
    var categoryId = $(this).val();
    var productSelect = $('#edit_product_id'); // 🔥 use modal ID

    if (categoryId) {
        $.ajax({
            url: '/get-products/' + categoryId,
            type: 'GET',
            success: function(data) {
                productSelect.empty();
                productSelect.append('<option value="">-- Select Product --</option>');
                $.each(data, function(key, product) {
                    productSelect.append('<option value="' + product.id + '">' + product.name + '</option>');
                });
            }
        });
    } else {
        productSelect.empty().append('<option value="">-- Select Product --</option>');
    }
});


        // Cancel Edit
        $(document).on('click', '.cancelEdit', function() {
            table.ajax.reload();
        });
    });

      $(document).on('click', '.deletebanner', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            Swal.fire({
                title: 'Delete?',
                text: "This will permanently delete the banner!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ url('delete-banner') }}/" + id,
                        type: 'DELETE',
                        data: {
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Deleted!',
                                text: response.success,
                                timer: 1500,
                                showConfirmButton: false
                            });
                            table.ajax.reload();
                        }
                    });
                    table.ajax.reload();
                }
            });
        });



</script>

@endsection