@extends('admin.layout.template')
@section('title', 'Products')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <!-- Add Product Card -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title d-flex align-items-center gap-1">
                            <iconify-icon icon="solar:box-bold-duotone" class="text-primary fs-20"></iconify-icon>
                            Add Product
                        </h4>
                    </div>
                    <div class="card-body">
                        <form id="addProductForm" enctype="multipart/form-data">
                            @csrf
                            <div class="row g-3">
                                <div class="col-lg-4">
                                    <label class="form-label">Category</label>
                                    <select name="category_id" id="categorySelect" class="form-control" required>
                                        <option value="">Select Category</option>
                                        @foreach(App\Models\Category::all() as $cat)
                                        <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-lg-4">
                                    <label class="form-label">Subcategory</label>
                                    <select name="sub_category_id" id="subcategorySelect" class="form-control">
                                        <option value="">Select Subcategory</option>
                                    </select>
                                </div>

                                <div class="col-lg-4">
                                    <label class="form-label">Product Name</label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter product name"
                                        required>
                                </div>

                                <div class="col-lg-4">
                                    <label class="form-label">Price</label>
                                    <input type="number" name="price" class="form-control" placeholder="Enter price"
                                        required>
                                </div>

                                <div class="col-lg-4">
                                    <label class="form-label">Discount Price</label>
                                    <input type="number" name="discount_price" class="form-control"
                                        placeholder="Enter discount price">
                                </div>
                                <div class="col-lg-4">
                                    <div class="mb-3">
                                        <label class="form-label">Country</label>
                                        <select class="form-control" id="choices-multiple-remove-button" data-choices data-choices-removeItem name="country[]" multiple>
                                            @foreach(App\Models\Country::get() as $country)
                                            <option value="{{ $country->id }}"
                                                {{ isset($category) && $category->countries->contains($country->id) ? 'selected' : '' }}>
                                                {{ $country->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                        <!-- <select class="form-control" name="country_id" required>
                                            @foreach(App\Models\Country::get() as $item)
                                            <option value="{{$item->id}}">{{$item->name}}</option>
                                            @endforeach
                                        </select> -->
                                    </div>
                                </div>

                                <div class="col-lg-4">
                                    <label class="form-label">Images (Multiple)</label>
                                    <input type="file" name="images[]" id="imageInput" class="form-control" multiple
                                        required accept="image/*">
                                    <div id="previewContainer"></div>
                                </div>

                                

                                <div class="col-lg-4">
                                    <label class="form-label">Product Type</label>
                                    <select name="product_type" id="product_type" class="form-control">
                                        <option value="standard">Standard</option>
                                        <option value="hamper">Hamper</option>
                                        <option value="customized_gift">Customized Gift</option>
                                        <option value="gift_voucher">Gift Voucher</option>
                                    </select>
                                </div>



                                <!-- Customized Gift Fields -->
                                <div class="col-lg-4 customFields d-none">
                                    <label>Custom Photo</label>
                                    <input type="file" name="custom_photo" id="customPhotoInput" accept="image/*"
                                        class="form-control">
                                    <div id="customPhotoPreview"></div>
                                </div>
                                <div class="col-lg-4 customFields d-none">
                                    <label>Custom Text</label>
                                    <input type="text" name="custom_text" class="form-control">
                                </div>
                                <div class="col-lg-4 customFields d-none">
                                    <label>Custom Color</label>
                                    <input type="text" name="custom_color" class="form-control">
                                </div>
                                <div class="col-lg-12 customFields d-none">
                                    <label>Custom Message</label>
                                    <textarea name="custom_message" class="form-control"></textarea>
                                </div>

                                <!-- Gift Voucher Fields -->
                                <div class="col-lg-4 voucherFields d-none">
                                    <label>Voucher Brand</label>
                                    <input type="text" name="voucher_brand" class="form-control">
                                </div>
                                <div class="col-lg-4 voucherFields d-none">
                                    <label>Voucher Code</label>
                                    <input type="text" name="voucher_code" class="form-control">
                                </div>
                                <div class="col-lg-4 voucherFields d-none">
                                    <label>Voucher Amount</label>
                                    <input type="number" name="voucher_amount" class="form-control">
                                </div>
                                <div class="col-lg-4 voucherFields d-none">
                                    <label>Voucher Value</label>
                                    <input type="number" name="voucher_value" class="form-control">
                                </div>
                                <div class="col-lg-4 voucherFields d-none">
                                    <label>Start Date</label>
                                    <input type="date" name="voucher_start_date" class="form-control">
                                </div>
                                <div class="col-lg-4 voucherFields d-none">
                                    <label>End Date</label>
                                    <input type="date" name="voucher_end_date" class="form-control">
                                </div>

                                <div class="col-lg-12 mb3 ">
                                    <label class="form-label">Description</label>
                                    <div id="snow-editor" style="height: 200px;"></div>
                                    <input type="hidden" name="description" name="description" id="description">
                                </div>

                            </div>

                            <div class="text-end mt-3">
                                <button type="submit" class="btn btn-success">Save Product</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>


    </div>
</div>


<!-- ========================== JAVASCRIPT ========================== -->
<script>
$(document).ready(function() {

    // Load subcategories dynamically
    $('#categorySelect').on('change', function() {
        let catId = $(this).val();
        $('#subcategorySelect').html('<option value="">Loading...</option>');
        $.get("{{ url('get-subcategories') }}/" + catId, function(data) {
            let html = '<option value="">Select Subcategory</option>';
            $.each(data, function(i, subcat) {
                html += `<option value="${subcat.id}">${subcat.name}</option>`;
            });
            $('#subcategorySelect').html(html);
        });
    });



    // Add Product
    $('#addProductForm').submit(function(e) {
        e.preventDefault();
        var formData = new FormData(this);
        $.ajax({
            url: "{{ route('product.store') }}",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Added!',
                    text: response.success,
                    timer: 1500,
                    showConfirmButton: false
                });
                $('#addProductForm')[0].reset();
               
            },
            error: function(xhr) {
                let errors = xhr.responseJSON.errors;
                let errMsg = '';
                $.each(errors, function(k, v) {
                    errMsg += `• ${v}<br>`;
                    //errMsg += v + '\n';
                });
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    html: errMsg
                });
            }
        });
    });





    $('#product_type').on('change', function() {
        let type = $(this).val();
        $('.customFields, .voucherFields').addClass('d-none');
        if (type == 'customized_gift') $('.customFields').removeClass('d-none');
        if (type == 'gift_voucher') $('.voucherFields').removeClass('d-none');
    });
});

</script>

@endsection