<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('home_sections', function (Blueprint $table) {
            $table->id();

            $table->string('title');
            // Example: Occasions, Festivals, Gift Hamper, Corporate Gifts

            $table->enum('source_type', ['category', 'subcategory']);
            // What this section is based on

            $table->unsignedBigInteger('source_id');
            // category_id OR subcategory_id

            $table->string('ui_type');
            // banner_card, icon_card, product_card


            $table->integer('position')->default(0);

            $table->boolean('status')->default(1);

            $table->timestamps();

            // Optional FK (recommended but not forced)
            // $table->foreign('source_id')->references('id')->on('categories');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('home_sections');
    }
};
