<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('carts', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY

            $table->string('session_id')->nullable(); // store before login

            $table->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->onDelete('cascade'); // update after login

            $table->foreignId('product_id')
                ->constrained('products')
                ->onDelete('cascade'); // product reference

            $table->integer('quantity')->default(1);

            $table->decimal('price', 10, 2); // price at time of add

            $table->timestamps(); // created_at & updated_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('carts');
    }
};
