<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
             // New product type field
            $table->enum('product_type', ['hamper', 'customized_gift', 'gift_voucher', 'standard'])
                ->default('standard')
                ->after('is_trending'); // change existing_column to correct field

            // Hamper fields
            $table->json('hamper_items')->nullable()->after('product_type'); // list of product IDs & qty
            $table->text('hamper_description')->nullable()->after('hamper_items');

            // Customized gift fields
            $table->string('custom_photo')->nullable()->after('hamper_description'); // image path
            $table->string('custom_text')->nullable()->after('custom_photo');
            $table->text('custom_message')->nullable()->after('custom_text');
            $table->string('custom_color')->nullable()->after('custom_message');

            // Gift voucher fields
            $table->decimal('voucher_amount', 10, 2)->nullable()->after('custom_color');
            $table->string('voucher_brand')->nullable()->after('voucher_amount');
            $table->date('voucher_start_date')->nullable()->after('voucher_brand');
            $table->date('voucher_end_date')->nullable()->after('voucher_start_date');
            $table->decimal('voucher_value', 10, 2)->nullable()->after('voucher_end_date');
            $table->string('voucher_code')->nullable()->unique()->after('voucher_value');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
             $table->dropColumn([
                'product_type',
                'hamper_items',
                'hamper_description',
                'custom_photo',
                'custom_text',
                'custom_message',
                'custom_color',
                'voucher_amount',
                'voucher_brand',
                'voucher_start_date',
                'voucher_end_date',
                'voucher_value',
                'voucher_code',
            ]);
        });
    }
};
