<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stadium_blocks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('stadium_id')->constrained('stadiums')->onDelete('cascade');
            $table->string('name'); // e.g., "BLOCK A", "VIP", "EAST GALLERY"
            $table->string('position')->nullable(); // e.g., "North Side", "Right Wing"
            $table->integer('capacity')->default(0); // seats count
            $table->decimal('base_price', 10, 2)->default(0);
            $table->string('image')->nullable(); // optional block photo
             $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stadium_blocks');
    }
};
