<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\admin\{
    RoleController,
    UserController,
    SettingsController,
    PartnerController,
    DriverController,
    VendorController,
    FareController,
    BookingController
};
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\WebVendorController;
use App\Http\Controllers\WebDriverController;
use Illuminate\Support\Facades\Auth;
// ------------------------------------------------------
// Public Routes
// ------------------------------------------------------
Route::get('/test', function () {
    return view('test');
})->name('test');

Route::fallback(function () {
    return response()->view('errors.404-custom', [], 404);
});

Route::view('/', 'index')->name('index');

Route::view('/control-panel', 'auth.login');



Route::get('/trip/{id}/invoice', [BookingController::class, 'downloadInvoice'])->name('trip.invoice.download');

Auth::routes();

// ------------------------------------------------------
// Admin Routes (web guard)
// ------------------------------------------------------
Route::controller(BookingController::class)->group(function () {
    Route::post('/save/trip/lifecycle', 'savetriplifecycle')->name('save-trip-lifecycle');
});
Route::controller(WebVendorController::class)->group(function () {
    Route::post('/assign/driver', 'assignDriver')->name('assign-driver');
});
Route::get('/get/reviews', [BookingController::class, 'getreviews'])->name('get-reviews');
Route::middleware('auth')->group(function () {
    Route::get('/home', fn() => view('home'))->name('home');

    Route::resource('roles', RoleController::class);
    Route::resource('users', UserController::class);

    // Zones
    Route::view('/zones', 'zones')->name('zones');
    Route::view('/add/zone', 'add-zone')->name('add-zone');
    Route::post('/add/zone', [SettingsController::class, 'addZone'])->name('store-zone');
    Route::get('/get/zone', [SettingsController::class, 'getZone'])->name('get-zone');
    Route::get('/edit/zone/{id}', [SettingsController::class, 'editZone'])->name('edit-zone');
    Route::post('/update/zone', [SettingsController::class, 'updateZone'])->name('update-zone');
    Route::get('/delete/zone/{id}', [SettingsController::class, 'deleteZone'])->name('delete-zone');

    // Vehicle Categories
    Route::view('/Vehicle/Categories', 'vehicleCategory')->name('vehicleCategory');
    Route::post('/add/vehicleCategory', [SettingsController::class, 'addvehicleCategory'])->name('add-vehicleCategory');
    Route::get('/get/vehicleCategory', [SettingsController::class, 'getvehicleCategory'])->name('get-vehicleCategory');
    Route::post('/edit/vehicleCategory', [SettingsController::class, 'editvehicleCategory'])->name('edit-vehicleCategory');
    Route::get('/delete/vehicleCategory/{id}', [SettingsController::class, 'deletevehicleCategory'])->name('delete-vehicleCategory');

    
    // Banners
    Route::view('/banners', 'banners')->name('banners');
    Route::post('/add/banners', [SettingsController::class, 'addbanners'])->name('add-banners');
    Route::get('/get/banners', [SettingsController::class, 'getbanners'])->name('get-banners');
    Route::get('/delete/banners/{id}', [SettingsController::class, 'deletebanners'])->name('delete-banners');
    Route::view('/add/faq', 'add-faq')->name('add-faq');
    Route::view('/faq', 'faq')->name('faq');
    Route::post('/save/faq', [SettingsController::class, 'saveFAQ'])->name('save-faq');
       Route::post('/update/faq', [SettingsController::class, 'updateFAQ'])->name('update-faq');
    Route::get('/get/faq', [SettingsController::class, 'getFAQ'])->name('get-FAQ');
 Route::get('/delete/faq', [SettingsController::class, 'deleteFAQ'])->name('delete-faq');
    Route::get('/edit/faq', [SettingsController::class, 'editFAQ'])->name('edit-faq');

    // Partners
    Route::view('/partners', 'partner')->name('partners');
    Route::view('/customers', 'partner')->name('customers');
    Route::post('/add/partner', [PartnerController::class, 'addpartner'])->name('add-partner');
    Route::get('/get/partner', [PartnerController::class, 'getpartner'])->name('get-partner');
    Route::post('/edit/partner', [PartnerController::class, 'editpartner'])->name('edit-partner');
    Route::get('/delete/partner/{id}', [PartnerController::class, 'deletepartner'])->name('delete-partner');
    Route::get('/view/{role}/details/{id}', [PartnerController::class, 'viewpartner'])->name('view-partner');
 Route::get('/change/role/{role}/{id}', [PartnerController::class, 'changeRole'])->name('change-role');
 
    // Drivers
    Route::view('/drivers', 'driver.list')->name('drivers');
    Route::view('/add/driver', 'driver.add')->name('add-driver');
    Route::post('/add/driver', [DriverController::class, 'adddriver'])->name('store-driver');
    Route::get('/get/driver', [DriverController::class, 'getdriver'])->name('get-driver');
    Route::get('/edit/driver/{id}', [DriverController::class, 'editdriver'])->name('edit-driver');
    Route::post('/update/driver', [DriverController::class, 'updatedriver'])->name('update-driver');
    Route::get('/delete/driver/{id}', [DriverController::class, 'deletedriver'])->name('delete-driver');
    Route::get('/view/driver/{id}', [DriverController::class,  'viewdriver'])->name('view-driver');
    // Vendors
    Route::view('/vendors/list', 'vendor.list')->name('admin-vendors-list');
    Route::view('/add/vendor', 'vendor.add')->name('add-vendor');
    Route::post('/add/vendor', [VendorController::class, 'addvendor'])->name('store-vendor');
    Route::get('/get/vendor', [VendorController::class, 'getvendor'])->name('get-vendor');
    Route::get('/edit/vendor/{id}', [VendorController::class, 'editvendor'])->name('edit-vendor');
    Route::post('/update/vendor', [VendorController::class, 'updatevendor'])->name('update-vendor');
    Route::get('/delete/vendor/{id}', [VendorController::class, 'deletevendor'])->name('delete-vendor');
    Route::get('/view/vendor/{id}', [VendorController::class,  'viewVendor'])->name('view-vendor');

    // Vehicles
    Route::view('/vehicles', 'vehicle.list')->name('vehicles');
    Route::view('/add/vehicle', 'vehicle.add')->name('add-vehicle');
    Route::post('/save/vehicle', [DriverController::class, 'savevehicle'])->name('save-vehicle');
    Route::get('/get/vehicle', [DriverController::class, 'getvehicle'])->name('get-vehicle');
    Route::get('/edit/vehicle/{id}', [DriverController::class, 'editvehicle'])->name('edit-vehicle');
    Route::post('/update/vehicle', [DriverController::class, 'updatevehicle'])->name('update-vehicle');
    Route::get('/delete/vehicle/{id}', [DriverController::class, 'deletevehicle'])->name('delete-vehicle');
    Route::get('/delete/vehicle/image/{id}/{image}', [DriverController::class, 'deletevehicleImage'])->name('delete-vehicle-image');
    Route::get('/view/vehicle/{id}', [DriverController::class,  'viewvehicle'])->name('view-vehicle');

    // Brands & Settings
    Route::view('/brands', 'brands')->name('brands');
    Route::view('/settings', 'settings')->name('settings');
    Route::post('/update/settings', [SettingsController::class, 'updatesettings'])->name('update-settings');
    Route::post('/add/brand', [SettingsController::class, 'addbrand'])->name('add-brand');
    Route::post('/add/brand/model', [SettingsController::class, 'addbrandmodel'])->name('add-brand-model');
    Route::get('/get/brandmodel', [SettingsController::class, 'getbrandmodel'])->name('get-brandmodel');
    Route::post('/edit/brandmodel', [SettingsController::class, 'editbrandmodel'])->name('edit-brandmodel');
    Route::get('/delete/brandmodel/{id}', [SettingsController::class, 'deletebrandmodel'])->name('delete-brandmodel');

    // Fare
    Route::view('/fare', 'fare.list')->name('fare');
    Route::view('/add/fare', 'fare.add')->name('add-fare');
    Route::post('/add/fare', [FareController::class, 'addfare'])->name('store-fare');
    Route::get('/get/fare', [FareController::class, 'getfare'])->name('get-fare');
    Route::get('/edit/fare/{id}', [FareController::class, 'editfare'])->name('edit-fare');
    Route::post('/update/fare', [FareController::class, 'updatefare'])->name('update-fare');
    Route::get('/delete/fare/{id}', [FareController::class, 'deletefare'])->name('delete-fare');

    Route::post('/calculate-fare', [FareController::class, 'calculateFare']);

    // Bookings
    Route::controller(BookingController::class)->group(function () {
        Route::view('/bookings', 'booking.list')->name('bookings');
        Route::get('/get/bookings', 'getBookings')->name('get-bookings');

        Route::get('/delete/reviews/{id}', 'deletereviews')->name('delete-review');
        Route::post('/change/booking/status', 'changebookingstatus')->name('change-booking-status');
        Route::get('/get/booking/details', 'getBookingDetails')->name('get-booking-details');
        Route::get('/delete/booking/{id}', 'deletebooking')->name('delete-booking');
        Route::get('/add/trip/lifecycle/{id}', 'addtriplifecycle')->name('add-trip-lifecycle');
        // Route::post('/save/trip/lifecycle', 'savetriplifecycle')->name('save-trip-lifecycle');
    });
});

// ------------------------------------------------------
// Vendor OTP Login / Dashboard
// ------------------------------------------------------

Route::prefix('vendors')->as('vendor.')->group(function () {
    Route::view('/', 'web.vendors.login')->name('login');
    Route::controller(WebVendorController::class)->group(function () {
        Route::post('send-otp', 'sendOtp')->name('send-otp');
        Route::post('verify-otp', 'verifyOtp')->name('verify-otp');
        Route::get('verify-phone', 'verifyPhone')->name('verify-phone');
    });

    Route::view('/not-active', 'web.vendors.not-active')->name('not-active');
    Route::view('/success', 'web.vendors.success')->name('success');
    Route::middleware(['web', 'vendor'])->group(function () {
        Route::view('/bookings', 'web.vendors.bookings')->name('bookings');
        Route::view('/profile', 'web.vendors.dashboard')->name('profile');

        Route::controller(WebVendorController::class)->group(function () {
            Route::post('profile', 'profile')->name('profile');

            Route::get('/get/bookings', 'getBookings')->name('get-bookings');
            //     Route::post('/assign/driver', 'assignDriver')->name('assign-driver');
            Route::get('/get/booking/details', 'getBookingDetails')->name('get-booking-details');
            Route::get('add/profile', 'addProfile')->name('add-profile');
            Route::post('signout', 'signout')->name('signout');
            Route::post('/update/new/vendor', 'updatenewendor')->name('update-new-vendor');

            // Drivers
            Route::view('/drivers', 'web.vendors.driver.list')->name('drivers');
            Route::view('/add/driver', 'web.vendors.driver.add')->name('add-driver');
            Route::post('/add/driver', 'adddriver')->name('store-driver');
            Route::get('/get/driver', 'getdriver')->name('get-driver');
            Route::get('/edit/driver/{id}', 'editdriver')->name('edit-driver');
            Route::post('/update/driver', 'updatedriver')->name('update-driver');
            Route::get('/delete/driver/{id}', 'deletedriver')->name('delete-driver');
            Route::get('/view/driver/{id}',  'viewdriver')->name('view-driver');

            // Vehicles
            Route::view('/vehicles', 'web.vendors.vehicle.list')->name('vehicles');
            Route::view('/add/vehicle', 'web.vendors.vehicle.add')->name('add-vehicle');
            Route::post('/save/vehicle', 'savevehicle')->name('save-vehicle');
            Route::get('/get/vehicle', 'getvehicle')->name('get-vehicle');
            Route::get('/edit/vehicle/{id}', 'editvehicle')->name('edit-vehicle');
            Route::post('/update/vehicle', 'updatevehicle')->name('update-vehicle');
            Route::get('/delete/vehicle/{id}', 'deletevehicle')->name('delete-vehicle');
            Route::get('/delete/vehicle/image/{id}/{image}', 'deletevehicleImage')->name('delete-vehicle-image');
            Route::get('/view/vehicle/{id}', 'viewvehicle')->name('view-vehicle');
            Route::get('/add/trip/lifecycle/{id}', 'addtriplifecycle')->name('add-trip-lifecycle');
            // Route::post('assign/driver', 'assignDriver')->name('assign-driver');
            Route::get('/edit/profile', 'profile')->name('edit-profile');
            Route::post('/update/profile', 'updateProfile')->name('update-profile');
        });
    });
});
// ********* driver web section ***************

Route::prefix('driver')->as('driver.')->group(function () {
    Route::view('/', 'web.drivers.login')->name('login');
    Route::controller(WebdriverController::class)->group(function () {
        Route::post('send-otp', 'sendOtp')->name('send-otp');
        Route::post('verify-otp', 'verifyOtp')->name('verify-otp');
        Route::get('verify-phone', 'verifyPhone')->name('verify-phone');
    });

    Route::view('/not-active', 'web.drivers.not-active')->name('not-active');
    Route::view('/success', 'web.drivers.success')->name('success');
    Route::middleware(['web', 'driver'])->group(function () {
        Route::view('/bookings', 'web.drivers.bookings')->name('bookings');
        Route::view('/dashboard', 'web.drivers.dashboard')->name('dashboard');

        Route::controller(WebdriverController::class)->group(function () {
            Route::get('profile', 'profile')->name('profile');
            Route::get('/add/trip/lifecycle/{id}', 'addtriplifecycle')->name('add-trip-lifecycle');
            Route::get('add/profile', 'addProfile')->name('add-profile');
            Route::post('signout', 'signout')->name('signout');
            Route::post('/update/new/driver', 'updateNewDriver')->name('update-new-driver');
            Route::get('/get/bookings', 'getBookings')->name('get-bookings');
            Route::get('/get/booking/details', 'getBookingDetails')->name('get-booking-details');
            Route::get('/edit/profile', 'editprofile')->name('edit-profile');
        });
    });
});
