<?php
// use Illuminate\Auth\Middleware\Authenticate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\api\partneruser\FareController;
use App\Http\Controllers\api\partneruser\LoginController;
use App\Http\Controllers\api\vendor\AuthController;
use App\Http\Controllers\api\vendor\BookingController;
use App\Http\Controllers\api\vendor\VendorController;
use App\Http\Controllers\api\driver\DriverController;
//*************** partner user apis *********************************/
Route::post('/calculate-fare', [FareController::class, 'calculateFare']);
Route::post('/faq', [LoginController::class, 'faq']);
Route::controller(LoginController::class)->group(function () {
    Route::post('login', 'login');
    Route::post('send-otp', 'sendOtp');
    Route::post('verify-otp', 'verifyOtp');
    Route::get('privacy/terms/cancellation', 'getSettings');
});
Route::middleware('auth:sanctum', 'check.user.status')->group(function () {
    Route::controller(LoginController::class)->group(function () {
        Route::post('logout', 'logout');
        Route::post('update/profile', 'updateProfile');
        Route::get('get/profile', 'profile');
        Route::post('request/as/agency', 'requestAsAgency');
        Route::post('account/delete/request', 'accountDeleteRequest');
    });
    Route::controller(FareController::class)->group(function () {
        Route::get('get/banners', 'banners');
        Route::post('choose/your/ride', 'chooseRide');
        Route::post('choose/your/car', 'chooseCar');
        Route::post('add/commission', 'addCommission');
        Route::post('book/cab', 'bookCab');
        Route::post('get/bookings', 'getBookings');
        Route::get('payment/history', 'paymentHistory');
        Route::get('get/recent/search', 'getRecentSearch');
        Route::post('get/recent/search/details', 'getRecentSearchDetails');
        Route::get('get/booking/details', 'getBookingDetails');
        Route::post('add/review', 'addReview');
        Route::get('get/agency/details', 'getAgencyDetails');
        Route::get('get/vehicle/models', 'getVehicleModels');
        Route::get('/trip/invoice', 'downloadInvoice');
        Route::post('/create-razorpay-order', 'createRazorpayOrder');
        Route::get('notifications', 'notifications');
        Route::post('cancel/booking', 'cancelBooking');
    });
});
//*************** partner user apis end *********************************/

//*************** driver apis *********************************/
Route::prefix('driver')->group(function () {
    Route::controller(DriverController::class)->group(function () {
        Route::post('send-otp', 'sendOtp');
        Route::post('verify-otp', 'verifyOtp');
    });
    Route::middleware('auth:sanctum', 'check.driver.status')->group(function () {
        Route::controller(DriverController::class)->group(function () {
            Route::post('logout', 'logout');
            Route::post('update/profile', 'updateProfile');
            Route::get('get/profile', 'profile');
            Route::post('get/bookings', 'getBookings');
            Route::get('get/booking/details', 'getBookingDetails');
            Route::post('trip/start', 'startTripDay');
            Route::post('trip/update', 'updateTripDay');
            Route::post('change/availabilty/status', 'changeAvailabiltyStatus');
            Route::get('get/latest/trip', 'getLatestTrip');
            Route::get('notifications', 'notifications');
             Route::post('account/delete/request', 'accountDeleteRequest');
        });
    });

    Route::controller(LoginController::class)->group(function () {
    Route::get('privacy/terms/cancellation', 'getSettings');
});
});


//*************** driver apis end*********************************/

//*************** vendor apis*********************************/

Route::prefix('vendor')->group(function () {
     Route::controller(LoginController::class)->group(function () {
    Route::get('privacy/terms/cancellation', 'getSettings');
});
    Route::controller(AuthController::class)->group(function () {
        Route::post('send-otp', 'sendOtp');
        Route::post('verify-otp', 'verifyOtp');
    });
    Route::middleware('auth:sanctum', 'check.vendor.status')->group(function () {
        Route::controller(AuthController::class)->group(function () {
            Route::post('logout', 'logout');
            Route::post('update/profile', 'updateProfile');
            Route::get('get/profile', 'profile');
             Route::post('account/delete/request', 'accountDeleteRequest');
        });

        Route::controller(BookingController::class)->group(function () {
            Route::post('get/bookings', 'getBookings');
            Route::post('assign/driver', 'assignDriver');
            Route::post('available/drivers', 'getAvailableDrivers');
            Route::get('get/booking/details', 'getBookingDetails');
        });
        Route::controller(VendorController::class)->group(function () {
            Route::post('get/vehicles', 'getVehicles');
            Route::post('delete/vehicle', 'deleteVehicle');
            Route::post('get/vehicle/details', 'getVehicleDetails');
            Route::post('add/vehicle', 'addVehicle');
            Route::post('edit/vehicle', 'editVehicle');
            Route::post('get/drivers', 'getdrivers');
            Route::post('get/drivers/details', 'getDriverDetails');
            Route::post('add/driver', 'adddriver');
            Route::post('delete/driver', 'deletedriver');
            Route::get('get/zones', 'getZones');
            Route::get('get/vehicle/categories', 'getvehiclecategories');
            Route::get('notifications', 'notifications');
        });
    });

    //*************** vendor apis end*********************************/
});
