<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trip_life_cycles', function (Blueprint $table) {
             $table->id();
              $table->integer('booking_id');
              $table->string('day');
              $table->date('date');
               $table->decimal('actual_km', 8, 2)->nullable();
              $table->decimal('starting_meter_reading', 8, 2)->nullable();
              $table->decimal('ending_meter_reading', 8, 2)->nullable();
              $table->decimal('km_driven', 8, 2)->nullable();
              $table->decimal('additional_charge_collected', 8, 2)->nullable();
              $table->text('note')->nullable();           
              $table->decimal('remaining_km', 8, 2)->nullable();
              $table->timestamp('created_at')->useCurrent();
              $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
        Schema::table('trip_life_cycles', function (Blueprint $table) {
            $table->unique(['booking_id', 'date']);
        });
            }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trip_life_cycles');
    }
};
