<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fares', function (Blueprint $table) {
                $table->id();
                $table->integer('vehicle_type_id');
                $table->json('city_id');
                $table->decimal('base_rate', 10, 2);       
                 $table->decimal('base_km', 10, 2);  
                $table->decimal('additional_km_rate', 10, 2);        // after base distance
                $table->decimal('surge_charge', 10, 2)->nullable();  
                $table->date('surcharge_start_date')->nullable();
                $table->date('surcharge_end_date')->nullable();     
                $table->decimal('offer_charge', 10, 2)->nullable();  
                $table->date('offer_start_date')->nullable();
                $table->date('offer_end_date')->nullable();
                $table->decimal('toll_charge', 10, 2)->nullable();  
                $table->timestamp('created_at')->useCurrent();
                $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fares');
    }
};
