<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class BookingHistory extends Model
{
    protected $fillable = [
         'booking_id',
                'vendor_id' ,
                'vehicle_id' ,
                'booked_user_id' ,
                'role' ,
                'total_km',
                'departure_date' ,
                'return_date',
                'departure_time' ,
                'return_time',
                'pick_up',
                'drop_off',
                'stay_date' ,
                'stay_locations' ,
                'adults',
                'children' ,
                'client_name' ,
                'client_mobile_number' ,
                'client_email',
                'base_fare',
                'commission_rate' ,
                'tax',
                'total_fare' ,
                'platform_fee',
                'paid_amount' ,
                'payment_id' ,
                'payment_status',
                'razorpay_order_id'
    ];

    
    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('d F Y H:i:s'); // Example: 01 August 2025 01:30:33
    }
}
