<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckDriverStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user(); // assuming Sanctum or Passport is used

        if ($user && $user->status === 'BLOCKED') {
            // Invalidate current token
            $request->user()->currentAccessToken()->delete();

            return response()->json([
                'status' => false,
                'message' => 'Your account has been blocked. Please contact support.',
                'force_logout' => true
            ], 403);
        }

        return $next($request);
    }
}
