<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Zone;
use App\Models\Partner;
use Yajra\DataTables\Facades\DataTables;

class PartnerController extends Controller
{
    //*********************************** Partner  section start *****************************/

    public function addPartner(Request $request)
    {
        $image = '';

        if ($request->photo) {
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/partner/'), $image);
        }
        $res = Partner::insert([
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'address' => $request->address,
            'district' => $request->district,
            'state' => $request->state,
            'postal_code' => $request->postal_code,
            'country' => $request->country,
            'image' => $image,
            'agency_name' => $request->agency_name,
            'agency_gst_number' => $request->agency_gst_number,
            'role' => $request->role
        ]);
        if ($res == 1)
            return redirect()->back()->with('success', 'Partner added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getPartner(Request $request)
    {
        if ($request->ajax()) {
            $data = Partner::where('role', $request->role)
             ->orderBy('id', 'DESC')
             ->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('name', function ($data) {
                    if ($data->image == NULL) {
                        $img = asset("assets/images/no-image");
                    } else {
                        $img = asset("uploads/partner/" . $data->image);
                    }
                    return  ' <div class="d-flex align-items-center">
                                            <div class="h-35 w-35 d-flex-center b-r-10 overflow-hidden me-2">
                                             <a href="' . route('view-partner', ['role' => $data->role, 'id' => $data->id]) . '">
                                                <img src=' . $img . ' alt="" class="img-fluid">
                                            </a>
                                            </div>
                                            <div class="d-flex">
                                             <a href="' . route('view-partner', ['role' => $data->role, 'id' => $data->id]) . '" class="btn btn-light-primary icon-btn b-r-4" ><span class="fw-medium">' . $data->name . '</span></a>
                                                
                                            </div>
                                        </div>';
                })
                ->addColumn('phone', function ($data) {
                    return   $data->phone;
                })
                ->addColumn('role_change_request', function ($data) {
                    if( $data->role_change_request=='None')
                    return   $data->role_change_request;
                else
                     return '<a href="' . route('change-role', ['role' => $data->role_change_request, 'id' => $data->id]) . '" class="badge text-light-danger"> ' . $data->role_change_request. '</a>';
                    
                })
                ->addColumn('email', function ($data) {
                    return    $data->email;
                })
                ->addColumn('status', function ($data) {
                    if ($data->status == 'BLOCKED')
                        return '<span class="badge text-light-danger"> ' . $data->status . '</span>';
                    else
                        return  '<span class="badge text-light-success">' . $data->status . '</span>';
                })

                ->addColumn('action', function ($data) {
                    $html = '';
                    if (auth()->user()->can('view-partner')) {
                        $html .= '    <a href="' . route('view-partner', ['role' => $data->role, 'id' => $data->id]) . '" class="btn btn-light-primary icon-btn b-r-4" ><i class="ti ti-eye text-primary"></i></a>';
                    }
                    if (auth()->user()->can('edit-partner')) {
                        $html .= '    <a href="#" class="btn btn-light-success icon-btn b-r-4" data-bs-toggle="modal" data-bs-target="#add_discount' . $data->id . '"><i class="ti ti-edit text-success"></i></a>
                           <div class="modal fade" id="add_discount' . $data->id . '" tabindex="-1" aria-labelledby="exampleModalLabel"  aria-hidden="true">

                             
                         <form action="' . route('edit-partner') . '" method="post" enctype="multipart/form-data">
                                    <div class="modal-dialog modal-dialog-centered modal-xl" id="staticBackdrop">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h1 class="modal-title f-w-500 fs-5" id="exampleModalLabel1">Edit </h1>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body app-form">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Name</label>
                                                               
                                                            <input type="hidden" class="form-control" name="_token" value="' . csrf_token() . '">
                                                            <input type="hidden" class="form-control" name="id" value="' . $data->id . '">
                                                            <input type="text" class="form-control" name="name" value="' . $data->name . '">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        
                                                        <div class="mb-3">
                                                            <label class="form-label">Phone </label>
                                                            <input type="text" name="phone" value="' . $data->phone . '" class="form-control" oninput="this.value = this.value.replace(/[^0-9]/g, "")" maxlength="12">
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="col-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Email address</label>
                                                            <input type="email" name="email" value="' . $data->email . '" class="form-control">
                                                        </div>
                                                    </div>

                                                       <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Image</label>
                                                            <input type="file" class="form-control" name="photo">
                                                        </div>
                                                    </div>

                                                     <div class="col-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Address</label>
                                                            <input type="text" name="address" value="' . $data->address . '" class="form-control">
                                                         
                                                        </div>
                                                    </div>
                                                
                                                     
                                                    <div class="col-lg-3 col-md-3">
                                                        <div class="input-block mb-3">
                                                            <label class="form-label">Status</label>
                                                            <select class="form-control" name="status">
                                                             <option value="' . $data->status . '">' . $data->status . '</option>
                                                            <option value="ACTIVE">ACTIVE</option>
                                                            <option value="BLOCKED">BLOCKED</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-3 col-md-3">
                                                        <div class="input-block mb-3">
                                                            <label class="form-label">Role</label>
                                                            <select class="form-control" name="role">
                                                             <option value="' . $data->role . '">' . $data->role . '</option>
                                                            <option value="Partner">Partner</option>
                                                            <option value="Customer">Customer</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="mb-3">
                                                            <label class="form-label">District</label>
                                                            <input type="text" name="district" value="' . $data->district . '" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="mb-3">
                                                            <label class="form-label">State</label>
                                                            <div class="input-group">
                                                                <input class="form-control" value="' . $data->state . '" type="text" name="state">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="col-md-3">
                                                        <div class="mb-3">
                                                            <label class="form-label">Country</label>
                                                            <input type="text" class="form-control" value="' . $data->country . '" name="country">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="mb-3 floating-select">
                                                            <label class="form-label">Postal Code</label>
                                                            <input type="text" class="form-control" value="' . $data->postal_code . '" name="postal_code">
                                                        </div>
                                                    </div>
                                                
                              
                                                     <div class="col-md-4">
                                                        <div class="mb-3">
                                                            <label class="form-label">Agency Name</label>
                                                            <input type="text" class="form-control" value="' . $data->agency_name . '" name="agency_name">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3 floating-select">
                                                            <label class="form-label">Agency GST Number</label>
                                                            <input type="text" class="form-control" value="' . $data->agency_gst_number . '" name="agency_gst_number">
                                                        </div>
                                                    </div>
                                                     <div class="col-lg-4 col-md-4">
                                                        <div class="input-block mb-3">
                                                            <label class="form-label">Role change Request</label>
                                                            <select class="form-control" name="role_change_request">
                                                             <option value="' . $data->role_change_request . '">' . $data->role_change_request . '</option>
                                                            <option value="None">None</option>
                                                            <option value="CustomerToPartner">CustomerToPartner</option>
                                                            <option value="PartnerToCustomer">PartnerToCustomer</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                </div>
                                                        
                                               
                                            </div>

                                         
                                            <div class="modal-footer">
                                                <button class="btn btn-primary" type="submit" id="push"
                                                        data-bs-dismiss="modal">Save changes</button>
                                            </div>
                                        </div>
                                    </div>
                            </form>
                        </div>
';
                    }
                    if (auth()->user()->can('delete-partner')) {
                        $html .= '   <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount' . $data->id . '"><i class="ti ti-trash"></i></a>
                                                                <div class="modal custom-modal fade" id="delete_discount' . $data->id . '" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete zone</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('delete-partner', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>';
                    }


                    return $html;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }

    public function editPartner(Request $request)
    {
        $res = Partner::where('id', $request->id)
            ->update([
                'name' => $request->name,
                'email' => $request->email,
                'phone' => $request->phone,
                'address' => $request->address,
                'district' => $request->district,
                'state' => $request->state,
                'postal_code' => $request->postal_code,
                'country' => $request->country,
                'status' => $request->status,
                'agency_name' => $request->agency_name,
                'agency_gst_number' => $request->agency_gst_number,
                'role' => $request->role,
                'role_change_request'=>$request->role_change_request
            ]);
        if ($request->photo) {
            $data = Partner::where('id', $request->id)->first();
            if ((file_exists(public_path('uploads/partner/' . $data->image))) && ($data->image != NULL)) {
                unlink("uploads/partner/" . $data->image);
            }
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/partner/'), $image);


            $res = Partner::where('id', $request->id)
                ->update(['image' => $image]);
        }
        if ($res == 1)
            return redirect()->back()->with('success', 'Partner  updated successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function deletePartner(Request $request)
    {
        $data = Partner::where('id', $request->id)->first();
        if ((file_exists(public_path('uploads/partner/' . $data->image))) && ($data->image != NULL)) {
            unlink("uploads/partner/" . $data->image);
        }

        $res = Partner::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'Partner  deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }


    public function viewpartner(Request $request)
    {

        $res = Partner::where('id', $request->id)->first();
        return view('view-partner', ['data' => $res, 'role' => $request->role]);
    }

     public function changeRole(Request $request)
    {
        if($request->role=='CustomerToPartner'){
            $role='Partner';
        }
        if($request->role=='PartnerToCustomer'){
            $role='Customer';
        }
        $res = Partner::where('id', $request->id)
            ->update([
                'role' => $role,
                'role_change_request'=>'None'
            ]);
      
        if ($res == 1)
            return redirect()->back()->with('success', 'Partner role changed successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }
}
