<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Zone;
use App\Models\Fare;
use App\Models\VehicleCategory;
use Yajra\DataTables\Facades\DataTables;

class FareController extends Controller
{
    //*********************************** fare  section start *****************************/

    public function addfare(Request $request)
    {
        $exist = Fare::where('vehicle_type_id', $request->input('vehicle_type_id'))->first();
        //   if($exist!=null)
        //   {
        //      return redirect()->back()->with('error', 'You are already add Fare details for Vehicle type '.VehicleCategory::where('id',$request->input('vehicle_type_id'))->pluck('name')->first());   
        //   }
        $res = Fare::insert([
            'vehicle_type_id' => $request->input('vehicle_type_id'),
            'city_id' => json_encode($request->input('city_id')),
            'base_rate' => $request->base_rate,
            'base_km' => $request->base_km,
            'additional_km_rate' => $request->additional_rate_per_km,
            'surge_charge' => $request->surge_charge,
            'surcharge_start_date' => $request->surcharge_start_date,
            'surcharge_end_date' => $request->surcharge_end_date,
            'offer_charge' => $request->offer_charge,
            'offer_start_date' => $request->offer_start_date,
            'offer_end_date' => $request->offer_end_date,
            'toll_charge' => $request->toll_charge,
        ]);


        if ($res == 1)
            return redirect()->back()->with('success', 'Fare added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getfare(Request $request)
    {
        if ($request->ajax()) {
            $data = Fare::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('type', function ($data) {
                    return  VehicleCategory::where('id', $data->vehicle_type_id)->pluck('name')->first();
                })
                ->addColumn('zone', function ($data) {
                    $html = '';
                    foreach (json_decode($data->city_id) as $item) {
                        $html .= Zone::where('id', $item)->pluck('name')->first() . ', ';
                    }
                    return $html;
                })
                ->addColumn('base_fare', function ($data) {
                    return   $data->base_rate;
                })
                ->addColumn('base_km', function ($data) {
                    return   $data->base_km;
                })
                ->addColumn('additional_km', function ($data) {
                    return    $data->additional_km_rate;
                })

                ->addColumn('action', function ($data) {
                      $html = '';
                    if (auth()->user()->can('edit-fare')) {
                  $html .=' <a href="' . route('edit-fare', ['id' => $data->id]) . '" class="btn btn-light-success icon-btn b-r-4" ><i class="ti ti-edit text-success"></i></a>';
                    }
                    if (auth()->user()->can('delete-fare')) {
                            $html .='   <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount' . $data->id . '"><i class="ti ti-trash"></i></a>
                        <div class="modal custom-modal fade" id="delete_discount' . $data->id . '" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete zone</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('delete-fare', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>                                            
    ';
                    }
                    return $html;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }
    public function editfare(Request $request)
    {
        $res = Fare::where('id', $request->id)->first();
        return view('fare.edit', ['data' => $res]);
    }
    public function updatefare(Request $request)
    {
        $res = Fare::where('id', $request->id)
            ->update([
                'vehicle_type_id' => $request->input('vehicle_type_id'),
                'city_id' => json_encode($request->input('city_id')),
                'base_rate' => $request->base_rate,
                'base_km' => $request->base_km,
                'additional_km_rate' => $request->additional_rate_per_km,
                'surge_charge' => $request->surge_charge,
                'surcharge_start_date' => $request->surcharge_start_date,
                'surcharge_end_date' => $request->surcharge_end_date,
                'offer_charge' => $request->offer_charge,
                'offer_start_date' => $request->offer_start_date,
                'offer_end_date' => $request->offer_end_date,
                'toll_charge' => $request->toll_charge,
            ]);

        if ($res == 1)
            return redirect()->back()->with('success', 'fare  updated successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function deletefare(Request $request)
    {
        $data = Fare::where('id', $request->id)->first();
        if ((file_exists(public_path('uploads/fare/' . $data->image))) && ($data->image != NULL)) {
            unlink("uploads/fare/" . $data->image);
        }

        $res = Fare::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'fare  deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }
    //*********************************** fare  section end *****************************/


    public function calculateFare(Request $request)
    {
        $distance = floatval($request->distance); // in km
        $vehicleType = $request->vehicle_type;

        $fare = Fare::table('fares')->where('vehicle_type_id', $vehicleType)->first();

        if (!$fare) {
            return response()->json(['fare' => 0]);
        }

        $baseKm = $fare->base_km;
        $baseRate = $fare->base_rate;
        $additionalKmRate = $fare->additional_km_rate;
        $tollCharge = $fare->toll_charge;

        $totalFare = $baseRate;

        if ($distance > $baseKm) {
            $additionalKm = $distance - $baseKm;
            $totalFare += $additionalKm * $additionalKmRate;
        }

        $totalFare += $tollCharge;

        return response()->json(['fare' => round($totalFare, 2)]);
    }
}
