<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Zone;
use App\Models\Driver;
use App\Models\Vendors;
use App\Models\Vehicle;
use App\Models\BrandVehicle;
use App\Models\VehicleCategory;
use App\Models\Review;
use App\Models\BookingHistory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;

class DriverController extends Controller
{
    //*********************************** driver  section start *****************************/
    public function viewDriver(Request $request)
    {

        $res = Driver::where('id', $request->id)->first();
        return view('driver.view', ['data' => $res]);
    }
    public function adddriver(Request $request)
    {
        $image = '';
        $licence_image = '';
        if ($request->photo) {
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/driver/'), $image);
        }
        if ($request->licence) {
            $rand = rand(100, 999);
            $licence_image = time() . '.' . $request->licence->extension();
            $imageOriginalName = $request->licence->getClientOriginalName();
            $request->licence->move(public_path('uploads/driver/licence'), $licence_image);
        }
        //    print_r($request->all());
        // if($request->vendor_id=="NULL"){

        //             $vendor = new Vendors();
        //             $vendor->name=$request->name;
        //             $vendor->email=$request->email ;
        //             $vendor->phone=$request->phone ;
        //             $vendor->address=$request->address ;
        //             $vendor->district=$request->district ;
        //             $vendor->state=$request->state ;
        //             $vendor->country=$request->country ;
        //             $vendor->postal_code=$request->postal_code;
        //             $vendor->save();
        //             $vendorid= $vendor->id;
        // }else{
        $vendorid = $request->vendor_id;
        //    }

        $res = Driver::insert([
            'vendor_id' => $vendorid,
            'name' => $request->name,
            'phone' => $request->phone,
            'address' => $request->address,
            'aadhar_no' => $request->aadhar_no,
            'image' => $image,
            'licence_number' => $request->licence_number,
            'licence_validity' => $request->licence_validity,
            'licence' => $licence_image,
            'zone' => $request->zone_id
        ]);


        if ($res == 1)
            return redirect()->back()->with('success', 'Driver added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getdriver(Request $request)
    {
        if ($request->ajax()) {
            $data = Driver::orderBy('id', 'DESC');
            if ($request->filled('vendor_id')) {
                $data = $data->where('vendor_id', $request->vendor_id);
            }
            $data = $data->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('name', function ($data) {
                    if ($data->image == NULL) {
                        $img = asset("assets/images/no-image.png");
                    } else {
                        $img = asset("uploads/driver/" . $data->image);
                    }
                    return  '<a href="' . route('view-driver', ['id' => $data->id]) . '" class="text-primary">
                   <div class="d-flex align-items-center">
                                            <div class="h-35 w-35 d-flex-center b-r-10 overflow-hidden me-2">
                                                <img src=' . $img . ' alt="" class="img-fluid">
                                            </div>
                                            <div class="d-flex">
                                                <span class="fw-medium">' . $data->name . '</span>
                                            </div>
                                        </div>
                                        </a>';
                })
                ->addColumn('vendor', function ($data) {
                    return    '<a href="' . route('view-vendor', ['id' => $data->id]) . '" class="text-primary">' . Vendors::where('id', $data->vendor_id)->pluck('name')->first() . '</a>';
                })
                ->addColumn('phone', function ($data) {
                    return   $data->phone;
                })
                ->addColumn('address', function ($data) {
                    return   $data->address;
                })
                ->addColumn('License Validity', function ($data) {
                    return    $data->licence_validity;
                })
                ->addColumn('status', function ($data) {
                    if ($data->status == 'BLOCKED')
                        return '<span class="badge text-light-danger"> ' . $data->status . '</span>';
                    else
                        return  '<span class="badge text-light-success">' . $data->status . '</span>';
                })

                ->addColumn('action', function ($data) {
                    $html = '';
                    if (auth()->user()->can('view-driver')) {
                        $html .= '   <a href="' . route('view-driver', ['id' => $data->id]) . '" class="btn btn-light-primary icon-btn b-r-4" ><i class="ti ti-eye text-primary"></i></a>';
                    }
                    if (auth()->user()->can('edit-driver')) {
                        $html .= '     <a href="' . route('edit-driver', ['id' => $data->id]) . '" class="btn btn-light-success icon-btn b-r-4" ><i class="ti ti-edit text-success"></i></a>';
                    }
                    if (auth()->user()->can('delete-driver')) {
                        $html .= ' <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount' . $data->id . '"><i class="ti ti-trash"></i></a>
                        <div class="modal custom-modal fade" id="delete_discount' . $data->id . '" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete zone</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('delete-driver', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>                                            
    ';
                    }
                    return $html;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }
    public function editdriver(Request $request)
    {
        $res = Driver::where('id', $request->id)->first();
        return view('driver.edit', ['data' => $res]);
    }
    public function updatedriver(Request $request)
    {
        $res = Driver::where('id', $request->id)
            ->update([

                'vendor_id' => $request->vendor_id,
                'name' => $request->name,
                'phone' => $request->phone,
                'address' => $request->address,
                'aadhar_no' => $request->aadhar_no,
                'licence_number' => $request->licence_number,
                'licence_validity' => $request->licence_validity,
                'zone' => $request->zone_id,
                'status' => $request->status
            ]);
        if ($request->photo) {
            $data = Driver::where('id', $request->id)->first();

            if ((file_exists(public_path('uploads/driver/' . $data->image))) && ($data->image != NULL)) {
                unlink("uploads/driver/" . $data->image);
            }
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/driver/'), $image);


            $res = Driver::where('id', $request->id)
                ->update(['image' => $image]);
        }

        if ($request->licence) {

            $data = Driver::where('id', $request->id)->first();
            if ((file_exists(public_path('uploads/driver/licence/', $data->licence))) && ($data->licence != NULL)) {
                unlink("uploads/driver/licence/" . $data->licence);
            }
            $rand = rand(100, 999);
            $licence_image = time() . '.' . $request->licence->extension();
            $imageOriginalName = $request->licence->getClientOriginalName();
            $request->licence->move(public_path('uploads/driver/licence/'), $licence_image);
            $res =  Driver::where('id', $request->id)
                ->update([
                    'licence' => $licence_image,
                ]);
        }
        if ($res == 1)
            return redirect()->back()->with('success', 'driver  updated successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function deletedriver(Request $request)
    {
        $data = Driver::where('id', $request->id)->first();
        if ((file_exists(public_path('uploads/driver/' . $data->image))) && ($data->image != NULL)) {
            unlink("uploads/driver/" . $data->image);
        }

        $res = Driver::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'Driver  deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }
    //*********************************** driver  section end *****************************/


    //*********************************** vehicle  section start *****************************/

    public function savevehicle(Request $request)
    {
        // print_r($request->all());
        // die();
        if (Vehicle::where('plate_number', $request->plate_number)->first() != NULL) {
            return redirect()->back()->with('error', 'Vehicle Plate number already Exist');
        }
        $image = '';
        $licence_image = '';
        //  if($request->photo){
        //             $rand = rand(100, 999);
        //             $image = time() . '.' . $request->photo->extension();
        //             $imageOriginalName = $request->photo->getClientOriginalName();
        //             $request->photo->move(public_path('uploads/vehicle/'), $image);

        //         }

        $imagePaths = [];

        if ($request->hasFile('images')) {
            foreach ($request->file('images') as $file) {
                $filename = Str::random(20) . '.' . $file->getClientOriginalExtension();
                $destinationPath = public_path('uploads/vehicle');

                // Create the folder if it doesn't exist
                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0755, true);
                }

                $file->move($destinationPath, $filename);
                $imagePaths[] =  $filename; // Relative public path
            }
        }

        $res = Vehicle::insert([
            'vendor_id' => Driver::where('id', $request->driver_id)->pluck('vendor_id')->first(),
            'driver_id' => $request->driver_id,
            'model' => $request->brand,
            'vehicle_make' => $request->vehicle_make,
            'year_of_registration' => $request->year_of_registration,
            'seats' => $request->seats,
            'color' => $request->color,
            'fuel_type' => $request->fuel_type,
            'plate_number' => $request->plate_number,
            'reg_validity' => $request->reg_validity,
            'insurance_validity' => $request->insurance_validity,
            'tax_validity' => $request->tax_validity,
            'image' => json_encode($imagePaths),
            'vehicle_type' => BrandVehicle::where('id', $request->brand)->pluck('vehicle_type')->first(),

        ]);
        if ($res == 1)
            return redirect()->back()->with('success', 'Vehicle added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getvehicle(Request $request)
    {
        if ($request->ajax()) {
            $data = Vehicle::orderBy('id', 'DESC');
            if ($request->filled('vendor_id')) {
                $data = $data->where('vendor_id', $request->vendor_id);
            }
            $data = $data->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('name', function ($data) {
                    $bv = BrandVehicle::where('id', $data->model)->first();
                    $modelname = $bv ? $bv->model_name : '';
                    $img = '';
                    if ($data->image == NULL) {
                        $img = asset("assets/images/no-image");
                    } else {
                        // return json_decode($data->image) ;
                        foreach (json_decode($data->image) as $i => $img) {
                            if ($i == 0) {
                                $img = asset("uploads/vehicle/" . $img);
                                break; // Stop looping once 3 images collected
                            }
                        }
                    }
                    return  ' <div class="d-flex align-items-center">
                                            <div class="h-35 w-35 d-flex-center b-r-10 overflow-hidden me-2">
                                               <a href="' . route('view-vehicle', ['id' => $data->id]) . '"> <img src="' . $img . '" alt="" class="img-fluid"></a>
                                            </div>
                                            <div class="d-flex">
                                              <a href="' . route('view-vehicle', ['id' => $data->id]) . '">   <span class="fw-medium">' . $modelname . '</span></a>
                                            </div>
                                        </div>';
                })
                ->addColumn('type', function ($data) {
                    return  VehicleCategory::where('id', $data->vehicle_type)->pluck('name')->first();
                })
                ->addColumn('vendor', function ($data) {
                    return  Vendors::where('id', $data->vendor_id)->pluck('name')->first();
                })
                ->addColumn('driver', function ($data) {
                    return  Driver::where('id', $data->driver_id)->pluck('name')->first();
                })
                ->addColumn('seats', function ($data) {
                    return   $data->seats;
                })
                ->addColumn('astatus', function ($data) {
                    if ($data->is_available == 'Booked')
                        return '<span class="btn btn-danger"> ' . $data->is_available . '</span>';
                    elseif ($data->is_available == 'Available')
                        return  '<span class="btn btn-success">' . $data->is_available . '</span>';
                    elseif ($data->is_available == 'Maintenance')
                        return  '<span class="btn btn-warning">' . $data->is_available . '</span>';
                })
                ->addColumn('plate_number', function ($data) {
                    return    $data->plate_number;
                })
                ->addColumn('status', function ($data) {
                    if ($data->status == 'BLOCKED')
                        return '<span class="badge text-light-danger"> ' . $data->status . '</span>';
                    else
                        return  '<span class="badge text-light-success">' . $data->status . '</span>';
                })

                ->addColumn('action', function ($data) {
                    $html = '';
                    if (auth()->user()->can('view-vehicle')) {
                        $html .= '  <a href="' . route('view-vehicle', ['id' => $data->id]) . '" class="btn btn-light-primary icon-btn b-r-4" ><i class="ti ti-eye text-primary"></i></a>';
                    }
                    if (auth()->user()->can('edit-vehicle')) {
                        $html .= ' <a href="' . route('edit-vehicle', ['id' => $data->id]) . '" class="btn btn-light-success icon-btn b-r-4" ><i class="ti ti-edit text-success"></i></a>';
                    }
                    if (auth()->user()->can('delete-vehicle')) {
                        $html .= ' <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount' . $data->id . '"><i class="ti ti-trash"></i></a>
                        <div class="modal custom-modal fade" id="delete_discount' . $data->id . '" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete zone</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('delete-vehicle', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>                                            
    ';
                    }
                    return $html;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }
    public function editvehicle(Request $request)
    {
        $res = Vehicle::where('id', $request->id)->first();
        return view('vehicle.edit', ['data' => $res]);
    }
    public function updatevehicle(Request $request)
    {
        $image = '';
        $licence_image = '';


        $res = Vehicle::where('id', $request->id)
            ->update([
                'vendor_id' => Driver::where('id', $request->driver_id)->pluck('vendor_id')->first(),
                'driver_id' => $request->driver_id,
                'model' => $request->brand,
                'vehicle_make' => $request->vehicle_make,
                'year_of_registration' => $request->year_of_registration,
                'seats' => $request->seats,
                'color' => $request->color,
                'fuel_type' => $request->fuel_type,
                'plate_number' => $request->plate_number,
                'reg_validity' => $request->reg_validity,
                'insurance_validity' => $request->insurance_validity,
                'tax_validity' => $request->tax_validity,
                'is_available' => $request->is_available,
                'status' => $request->status,
                'vehicle_type' => BrandVehicle::where('id', $request->brand)->pluck('vehicle_type')->first(),

            ]);

        $imagePaths = [];

        if ($request->hasFile('images')) {
            foreach ($request->file('images') as $file) {
                $filename = Str::random(20) . '.' . $file->getClientOriginalExtension();
                $destinationPath = public_path('uploads/vehicle');

                // Create the folder if it doesn't exist
                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0755, true);
                }

                $file->move($destinationPath, $filename);
                $imagePaths[] =  $filename; // Relative public path
            }
            $vehicle = Vehicle::findOrFail($request->id);

            // Decode old image from DB
            $oldimage = json_decode($vehicle->image, true) ?? [];

            $allimage = array_merge($oldimage, $imagePaths);


            $res =  Vehicle::where('id', $request->id)
                ->update([
                    'image' => json_encode($allimage),
                ]);
        }



        if ($res == 1)
            return redirect()->back()->with('success', 'Vehicle  updated successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function deletevehicle(Request $request)
    {
        //  $data= Vehicle::where('id',$request->id)->first();
        //   if ((file_exists(public_path('uploads/vehicle/' . $data->image))) && ($data->image != NULL)) {
        //         unlink("uploads/vehicle/" . $data->image);
        //     }
        // if ((file_exists(public_path('uploads/driver/licence/', $data->licence))) && ($data->licence != NULL)) {
        //         unlink("uploads/driver/licence/" . $data->licence);
        //     }
        $res = Vehicle::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'Vehicle  deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function deletevehicleImage(Request $request)
    {
        $vehicle = Vehicle::where('id', $request->id)->first();
        $updatedImages = [];
        if ($vehicle->image != NULL) {
            $images = json_decode($vehicle->image); // this is already an array if casted

            $k = 0;
            foreach ($images as $i) {
                if ($i != $request->image) {
                    $updatedImages[$k] = $i;
                    $k++;
                }
            }

            // Optionally delete the file from public folder
            $imagePath = public_path('uploads/vehicle/' . $request->image);
            if (File::exists($imagePath)) {
                File::delete($imagePath);
            }

            $res =  Vehicle::where('id', $request->id)
                ->update([
                    'image' => json_encode($updatedImages),
                ]);
        }
        if ($res == 1)
            return redirect()->back()->with('success', 'Vehicle  deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function viewvehicle(Request $request)
    {
        $vehicle =  Vehicle::join('vendors', 'vehicles.vendor_id', '=', 'vendors.id')
            ->join('drivers', 'drivers.id', '=', 'vehicles.driver_id')
            ->select(
                'vehicles.*',
                'vehicles.model',
                'vehicles.vehicle_make',
                'vehicles.year_of_registration',
                'vehicles.seats',
                'vehicles.color',
                'vehicles.fuel_type',
                'vehicles.plate_number',
                'vehicles.reg_validity',
                'vehicles.insurance_validity',
                'vehicles.tax_validity',
                'vehicles.image',
                'vehicles.vehicle_type',
                'vendors.name as vendor_name',
                'drivers.name as drivers_name',
                'vendors.vendor_image'
            ) // select vendor fields as needed
            ->where('vehicles.id', $request->id)
            ->first();

            // $vehicle =  Vehicle::join('vendors', 'vehicles.vendor_id', '=', 'vendors.id')
            //  ->join('drivers', 'drivers.vendor_id', '=', 'vendors.id')
            // ->where('vehicles.id', $request->id)
            // ->first();

     
        $vehicle->model = BrandVehicle::where('id', $vehicle->model)->pluck('model_name')->first();
        if ($vehicle->image != NULL) {
            $gallery_images = [];
            foreach (json_decode($vehicle->image) as $i => $img) {
                if ($i == 3) {
                    break; // Stop looping once 3 images collected
                }
                $gallery_images[$i] = asset('uploads/vehicle/' . $img); // or Storage::url($img) if using storage
            }

            if ($vehicle->vendor_image == NULL) {
                $vehicle->vendor_image = asset('assets/images/user.jpg');
            } else {
                $vehicle->vendor_image = asset('uploads/vendor/' . $vehicle->vendor_image);
            }

            $vehicle->image = $gallery_images;
        }
        //  $vehicle->reviews=Review::where('vehicle_id',$request->vehicle_id)->get(); 
        $vehicle->reviews =  Review::select('reviews.id as reviewid', 'partners.name as user_name', 'partners.image as user_image', 'reviews.overall_rating', 'reviews.driver_rating', 'reviews.car_rating', 'reviews.comment', 'reviews.created_at')
            ->join('partners', 'partners.id', '=', 'reviews.user_id')
            ->where('reviews.vehicle_id', $request->vehicle_id)
            ->orderBy('reviews.id', 'desc')
            ->get();
        foreach ($vehicle->reviews as $item) {

            if ($item->image == NULL) {
                $item->image = asset('assets/images/user.jpg');
            } else {
                $item->image = asset('uploads/partner/' . $item->image);
            }
        }
        $vehicle->vehicle_type = VehicleCategory::where('id', $vehicle->vehicle_type)->pluck('name')->first();

        //** rating **** */

        $perStarAverage = Review::select(
            'car_rating',
            DB::raw('ROUND(AVG(car_rating), 1) as average'),
            DB::raw('COUNT(*) as count')
        )
            ->whereIn('car_rating', [1, 2, 3, 4, 5])
            ->where('vehicle_id', $request->id)
            ->groupBy('car_rating')
            ->orderBy('car_rating', 'desc')
            ->get();

        // print_r($perStarAverage);die();
        $vehicle->total_review_rate = $perStarAverage;

        // Initialize all ratings from 0 to 5 with default values
        $ratings = [];
        for ($i = 5; $i >= 0; $i--) {
            $ratings[$i] = [
                'rate' => $i,
                'average' => 0.0,
                'count' => 0,
            ];
        }

        // Overwrite with actual data from DB
        foreach ($perStarAverage as $row) {
            // Convert to percentage (assuming max rating is 5)
            $percentage = ($row->car_rating / 5) * 100;

            // Optional: round to 1 decimal place
            $percentage = round($percentage, 1);

            $ratings[$row->car_rating] = [
                'rate' => $row->car_rating,
                'average' => $percentage,
                'count' => (int) $row->count,
            ];
        }

        //  $perStarAverage->review_details=$ratings;
        $vehicle->review_star_rate = $ratings;

        // print_r($vehicle);die();
        return view('vehicle.view', ['data' => $vehicle]);
    }
    //*********************************** vehicle  section end *****************************/

    
    
}
