<?php

namespace App\Http\Controllers\api\driver;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Vendors;
use App\Models\Driver;
use App\Models\Vehicle;
use Illuminate\Database\QueryException;
use Throwable;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Models\BookingHistory;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Http;
use App\Models\Fare;
use App\Models\Zone;
use App\Models\SearchHistory;
use App\Models\VehicleCategory;
use App\Models\BrandVehicle;
use App\Models\Settings;
use App\Models\Review;
use Carbon\Carbon;
use App\Models\TripLifeCycle;
use Illuminate\Support\Facades\DB;
use App\Models\Notifications;

class DriverController extends Controller
{
  public function updateProfile(Request $request)
  {
    try {
      $res = Driver::where('id', auth()->user()->id)
        ->update([
          'name' => $request->name,
          'phone' => $request->phone,
          'address' => $request->address,
          'aadhar_no' => $request->aadhar_no,
          'licence_number' => $request->licence_number,
          'licence_validity' => $request->licence_validity,
          'zone' => $request->zone_id,
          'status' => $request->status,         
        ]);
      if ($request->photo) {
        $data = Driver::where('id', $request->id)->first();

        if ((file_exists(public_path('uploads/driver/' . $data->image))) && ($data->image != NULL)) {
          unlink("uploads/driver/" . $data->image);
        }
        $rand = rand(100, 999);
        $image = time() . '.' . $request->photo->extension();
        $imageOriginalName = $request->photo->getClientOriginalName();
        $request->photo->move(public_path('uploads/driver/'), $image);


        $res = Driver::where('id', $request->id)
          ->update(['image' => $image]);
      }

      if ($request->licence) {

        $data = Driver::where('id', $request->id)->first();
        if ((file_exists(public_path('uploads/driver/licence/', $data->licence))) && ($data->licence != NULL)) {
          unlink("uploads/driver/licence/" . $data->licence);
        }
        $rand = rand(100, 999);
        $licence_image = time() . '.' . $request->licence->extension();
        $imageOriginalName = $request->licence->getClientOriginalName();
        $request->licence->move(public_path('uploads/driver/licence/'), $licence_image);
        $res =  Driver::where('id', $request->id)
          ->update([
            'licence' => $licence_image,
          ]);
      }
      if ($res == 1) {
        return response()->json([
          'status' => true,
          'message' => 'Profile updated successfully',
          'driver_status' => Driver::where('id', auth()->user()->id)->pluck('status')->first()
        ]);
      }
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }


  public function profile(Request $request)
  {
    try {
      $user = auth()->user();
      if ($user->image == NULL) {
        $user->image = asset('assets/images/user.jpg');
      } else {
        $user->image = asset('uploads/driver/' . $user->image);
      }

      $user->makeHidden(['created_at', 'updated_at']);
      return response()->json([
        'status' => true,
        'profile' => $user,
        // 'total_drivers' => count(Driver::where('id', auth()->user()->id)->get()),
        'total_vehicles' => count(Vehicle::where('driver_id', auth()->user()->id)->get()),
        'total_rides' => count(BookingHistory::where('driver_id', auth()->user()->id)->get()),
        'total_active_ride' => count(BookingHistory::where('driver_id', auth()->user()->id)->where('booking_status', 'Running')->get()),
        'total_pending_ride' => count(BookingHistory::where('driver_id', auth()->user()->id)->where('booking_status', 'Upcoming')->get()),
      ]);
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }

  // otp verification

  public function sendOtp(Request $request)
  {

    $request->validate(['phone' => 'required']);

    $phone = $request->input('phone');
    $phone = preg_replace('/\s+/', '', $phone);
    // $otp = '12345';
    // Cache::put('otp_' . $phone, $otp, now()->addMinutes(10));
    // return response()->json([
    //   'status' => true,
    //   'message' => 'SUCCESS',
    //   'status_code' => 1000,

    // ]);

 if ($phone == '9188360241' || $phone == '+919188360241' || $phone == '919188360241') {
                $otp = '12345';
                Cache::put('otp_' . $phone, $otp, now()->addMinutes(10));
                return response()->json([
                    'status' => true,
                    'message' => 'SUCCESS',
                    'status_code' => 1000,

                ]);
            } else {
                $otp = rand(10000, 99999);
            }

    // Store OTP temporarily (e.g. 5 minutes)
    Cache::put('otp_' . $phone, $otp, now()->addMinutes(10));
    //    Cache::put('otp_' . $request->phone, $otp, 600);

    // Send OTP using SMS provider (Twilio, etc.)
    // e.g. SmsService::send($request->phone, "Your OTP is $otp");

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://api.connectpanels.com/whatsapp-api/v1.0/customer/112609/bot/41e497d0ee1d46b6/template',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => '{"payload":{"name":"opt","components":[{"type":"body","parameters":[{"type":"text","text":"' . $otp . '"}]},{"type":"button","sub_type":"url","index":0,"parameters":[{"type":"text","text":"' . $otp . '"}]}],"language":{"code":"en_US","policy":"deterministic"},"namespace":"7a028420_cf7c_4506_991f_70c592e6ab51"},"phoneNumber":"' . $request->phone . '"}',
      CURLOPT_HTTPHEADER => array(
        'Authorization: Basic e10791cf-89ac-4edd-8e12-f12a9db410ee-HN5RnWO',
        'Content-Type: application/json'
      ),
    ));

    $response = curl_exec($curl);

    // Convert to array
    $responseData = json_decode($response, true);

    // Use the data
    $messageId = $responseData['responseObject']['message_id'];
    $statusCode = $responseData['status']['code'];
    $statusDesc = $responseData['status']['desc'];
    curl_close($curl);
    return response()->json([
         'status' => true,
                'message' => $statusDesc,
                'status_code' => $statusCode,
      // 'message_id' => $messageId,
      // 'status_code' => $statusCode,
      // 'status_desc' => $statusDesc,
    ]);
  }

  public function verifyOtp(Request $request)
  {


    $request->validate([
      'phone' => 'required',
      'otp' => 'required'
    ]);
    $phone = $request->input('phone');
    $phone = preg_replace('/\s+/', '', $phone);

    //  $phone=$request->phone;
    $storedOtp = Cache::get('otp_' . $phone);

    if ($storedOtp && $storedOtp == $request->otp) {
      // OTP is valid
      // Authenticate or register user logic here

      $user = Driver::where('phone', $phone)->first();

      $user_account = 'exist-user';

      if ($user == null) {
        // Register new user
        $user = Driver::create([
          'phone' => $phone,
        ]);
        $user_account = 'new-user';
        $user = Driver::where('phone', $phone)->first();
      }

      // Check BLOCKED status
      if ($user->status == 'REQUESTED'||$user->status == 'BLOCKED') {
        if (!empty($user->name) && !empty($user->zone)) {
          return response()->json([
            'message' => 'Your account is blocked. Please contact support.'
          ], 403);
        }
      }

      $token = $user->createToken('auth_token')->plainTextToken;
      $user->makeHidden(['created_at', 'updated_at']);
      Cache::forget('otp_' . $phone);
      return response()->json([
        'status' => true,
        'message' => 'OTP verified',
        'user-type' => $user_account,
        'token' => $token,
        'user' => $user,

      ]);
    }

    return response()->json(['message' => 'Invalid OTP'], 422);
  }
  public function logout(Request $request)
  {
    // Delete current access token
    $request->user()->currentAccessToken()->delete();

    return response()->json([
      'status' => true,
      'message' => 'Logged out successfully.'
    ]);
  }

  public function getBookings(Request $request)
  {
    try {

      $bookings = BookingHistory::select('id', 'booking_id', 'departure_date', 'return_date', 'departure_time', 'return_time', 'pick_up', 'drop_off', 'stay_locations', 'booking_status', 'total_fare', 'paid_amount')
        ->where('driver_id', auth()->user()->id)
         ->orderBy('departure_date','DESC')
        ->get();
      foreach ($bookings as $item) {
        $raw = $item->stay_locations; // The double-encoded JSON string

        $firstDecode = json_decode($raw, true);              // returns a JSON string
        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array

        $locationString = is_array($locationsArray) ? implode(', ', $locationsArray) : '';

        $item->stay_locations = $locationString;
        //  $item->stay_locations_count = is_array($locationsArray) ? count($locationsArray) : 0;

        $departure = Carbon::parse($item->departure_date);
        $return = Carbon::parse($item->return_date);

        // Total days (inclusive)
        $totalDays = $departure->diffInDays($return) + 1; // +1 to include both start and end dates
        $nightCount = $totalDays - 1;

        // Final title
        $tripTitle = "{$nightCount}NIGHTS {$totalDays}DAYS";
        $item->title = $tripTitle;
      }

      return response()->json([
        'status' => true,
        'data' => $bookings,
      ]);
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }

  public function getBookingDetails(Request $request)
  {
    try {

      // $booking= BookingHistory::select('id','vehicle_id','driver_id','booking_id','total_km','departure_date','return_date','departure_time','return_time','pick_up','drop_off','stay_date','stay_locations','adults','children','client_name','client_mobile_number','client_email','booking_status','total_fare','paid_amount')
      // ->where('id',$request->booking_id)
      // ->first();
      $booking =  BookingHistory::select('id', 'booking_id', 'total_km', 'departure_date', 'return_date', 'departure_time', 'return_time', 'pick_up', 'drop_off', 'stay_date', 'stay_locations', 'adults', 'children', 'client_name', 'client_mobile_number', 'client_email')
        ->where('id', $request->booking_id)->first();
      $booking->makeHidden(['created_at', 'updated_at']);
      // ********** stay location  *********
      $raw = $booking->stay_locations; // The double-encoded JSON string
      $firstDecode = json_decode($raw, true);              // returns a JSON string
      $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array
      $booking->stay_locations = $locationsArray;
      // ********** stay date end  *********

      // ********** find titile  *********
      $departure = Carbon::parse($booking->departure_date);
      $return = Carbon::parse($booking->return_date);

      // Total days (inclusive)
      $totalDays = $departure->diffInDays($return) + 1; // +1 to include both start and end dates
      $nightCount = $totalDays - 1;

      // Final title
      $tripTitle = "{$nightCount}NIGHTS {$totalDays}DAYS";
      $booking->title = $tripTitle;
      // ********** find titile end  *********

      // ********** stay date  *********
      $raw = $booking->stay_date; // The double-encoded JSON string

      $firstDecode = json_decode($raw, true);              // returns a JSON string
      $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array

      $booking->stay_date = $locationsArray;
      $trip_life_cycle = TripLifeCycle::select('id as trip_life_cycle_id', 'booking_id', 'day', 'date as stay_date', 'actual_km', 'starting_meter_reading', 'ending_meter_reading', 'km_driven', 'additional_charge_collected', 'note', 'remaining_km')
        ->where('booking_id', $booking->id)->get();
      // ********** stay date end *********
      foreach ($trip_life_cycle as $trip) {
        $trip->stay_date = Carbon::parse($trip->date)->format('d F Y');
      }
      $booking->trip_life_cycle = $trip_life_cycle;
      return response()->json([
        'status' => true,
        'data' => $booking,
      ]);
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }

  public function startTripDay(Request $request)
  {
    $request->validate([
      'trip_life_cycle_id' => 'required|integer',
      'starting_meter_reading' => 'required',
    ]);

    $trip = TripLifeCycle::findOrFail($request->trip_life_cycle_id);

    $trip->starting_meter_reading = $request->starting_meter_reading;
    $trip->save();
    $trip->makeHidden(['created_at', 'updated_at']);
    return response()->json([
      'message' => 'Starting meter reading saved',
      'trip' => $trip
    ]);
  }

  public function updateTripDay(Request $request)
  {
    $request->validate([
      'trip_life_cycle_id' => 'required|integer',
      'ending_meter_reading' => 'nullable|numeric',
      'additional_charge_collected' => 'nullable|numeric',
      'note' => 'nullable|string',
    ]);

    $trip = TripLifeCycle::findOrFail($request->trip_life_cycle_id);

    $trip->ending_meter_reading = $request->ending_meter_reading;

    if ($trip->starting_meter_reading !== null && $request->ending_meter_reading !== null) {
      $trip->km_driven = $trip->ending_meter_reading - $trip->starting_meter_reading;
    }

    $trip->additional_charge_collected = $request->additional_charge_collected;
    $trip->note = $request->note;
    $trip->save();

    // 2️⃣ Recalculate remaining_km for ALL trip days for this booking
    $booking = BookingHistory::find($trip->booking_id);
    if (!$booking) {
      return redirect()->back()->with('error', 'Booking not found.');
    }

    $totalKm = $booking->total_km;

    $tripLifeCycles = TripLifeCycle::where('booking_id', $trip->booking_id)
      ->orderBy('date')
      ->get();

    $cumulativeKm = 0;

    foreach ($tripLifeCycles as $trip) {
      $cumulativeKm += $trip->km_driven ?? 0;
      $remainingKm = $totalKm - $cumulativeKm;

      $trip->remaining_km = $remainingKm;
      $trip->save();
    }
    $trip = TripLifeCycle::findOrFail($request->trip_life_cycle_id);
    $trip->makeHidden(['created_at', 'updated_at']);
    return response()->json([
      'message' => 'Trip day updated successfully',
      'trip' => $trip
    ]);
  }
 public function getLatestTrip(Request $request)
  {
    try {

      $booking = BookingHistory::select('id', 'booking_id', 'departure_date', 'return_date', 'departure_time', 'return_time', 'pick_up', 'drop_off', 'stay_locations', 'booking_status', 'total_fare', 'paid_amount')
        ->where('driver_id', auth()->user()->id)
        ->orderBy('departure_date','ASC')
          ->where('departure_date','>=',date('Y-m-d',strtotime(now())))
        ->whereNotIn('booking_status',['Completed','Canceled'])
        ->first();
     if($booking!=null){
        $raw = $booking->stay_locations; // The double-encoded JSON string

        $firstDecode = json_decode($raw, true);              // returns a JSON string
        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array

        $locationString = is_array($locationsArray) ? implode(', ', $locationsArray) : '';

        $booking->stay_locations = $locationString;
        //  $booking->stay_locations_count = is_array($locationsArray) ? count($locationsArray) : 0;

        $departure = Carbon::parse($booking->departure_date);
        $return = Carbon::parse($booking->return_date);

        // Total days (inclusive)
        $totalDays = $departure->diffInDays($return) + 1; // +1 to include both start and end dates
        $nightCount = $totalDays - 1;

        // Final title
        $tripTitle = "{$nightCount}NIGHTS {$totalDays}DAYS";
        $booking->title = $tripTitle;
      
     }
      return response()->json([
        'status' => true,
        'data' => $booking,
      ]);
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }

   public function changeAvailabiltyStatus(Request $request)
  {
    try {

      $res = Driver::where('id', auth()->user()->id)
        ->update([
          'is_availabile_status' => $request->is_availabile_status,         
        ]);
    

    
      if ($res == 1) {
        return response()->json([
          'status' => true,
          'message' => 'Status updated successfully',
        ]);
      }
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }


      public function notifications(Request $request)
    {
        try {      
           
            $data=Notifications::where('driver_id', auth()->user()->id)
                ->get();

            return response()->json([
                'status' => true,
                'data' => $data,
            ]);
        } catch (QueryException $e) {
            return response()->json(['error' => 'Database error ' . $e], 500);
        } catch (Throwable $e) {
            return response()->json(['error' => 'Something went wrong ' . $e], 500);
        }
    }
}
