<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('brand_vehicles', function (Blueprint $table) {
             $table->id();
             $table->string('vehicle_type');
             $table->integer('brand');
             $table->string('model_name');
             $table->integer('min_passengers')->default(0);
             $table->integer('max_passengers')->default(0);       
              $table->integer('base_fare');
             $table->integer('fare_per_km');    
            $table->timestamp('created_at')->useCurrent();
             $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('brand_vehicles');
    }
};
