<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vehicles', function (Blueprint $table) {
             $table->id();
             $table->integer('vendor_id');
             $table->integer('driver_id');
             $table->integer('vehicle_id');
             $table->integer('model');
             $table->string('vehicle_make');
             $table->integer('year_of_registration');            
             $table->integer('seats'); 
             $table->string('color');
             $table->enum('fuel_type', ['Petrol', 'Diesel','CNG','Electric']);
             $table->string('plate_number')->unique();
             $table->date('reg_validity');
             $table->date('insurance_validity');
             $table->date('tax_validity');
             $table->enum('is_available', ['Available', 'Booked', 'Maintenance'])->default('available');
             $table->json('image');
             $table->string('status')->default('ACTIVE');
             $table->integer('overall_review_rate');
             $table->timestamp('created_at')->useCurrent();
             $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vehicles');
    }
};
