@extends('layouts.login-template')

@section('content')
<div class="app-wrapper d-block">
    <div class="">
        <!-- Body main section starts -->
        <main class="w-100 p-0">
            <!-- Login to your Account start -->
            <div class="container-fluid">
                <div class="row">

                    <div class="col-12 p-0">
                        <div class="login-form-container" style="background-image:url('{{asset('build/assets/vendor-bg.webp')}}');">
                            <div class="mb-4">
                                <a class="logo" href="/">
                                    <img alt="#" src="{{asset('assets/images/logo/3.png')}}" class="" style="width:100%;">
                                </a>
                            </div>
                            <div class="form_container">
                                <form method="POST" action="{{ route('vendor.send-otp') }}" class="app-form">
                                    @csrf

                                    <div class="mb-3 text-center">
                                        <h3>Go Ahead And Set Up Your Account</h3>

                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="phoneId">Mobile Number</label>
                                        <input id="phone" type="tel"
                                            class="form-control @error('phone') is-invalid @enderror"
                                            name="phone"
                                            value="{{ old('phone') }}"
                                            required
                                            pattern="^\+91[6-9][0-9]{9}$"
                                            title="Enter valid number like +911234567890"
                                            maxlength="13"
                                            autocomplete="phone"
                                            placeholder="+911234567890"
                                            autofocus>

                                        @error('phone')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror

                                    </div>


                                    <div>
                                        <button type="submit" class="btn btn-primary w-100">
                                            Send OTP
                                        </button>

                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Login to your Account end -->
        </main>
        <!-- Body main section ends -->
    </div>
</div>
@endsection