@extends('layouts.vendor-template')

@section('content')

        <!-- Main Section start -->
        <main>
            
     <div class="container-fluid">

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                    <h4>Add Driver</h4>
                </div>
                    <div class="card-body px-5">
                         <form action="{{route('vendor.add-driver')}}" method="post" enctype="multipart/form-data">
                                @csrf
                         <div class="row">
                                                 <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Select Vendor</label>
                                                            <select class="form-control" name="vendor_id">
                                                                <!-- <option value="NULL">Set as this driver as vendor</option> -->
                                                                @foreach(App\Models\Vendors::where('status','ACTIVE')->get() as $item)
                                                                    <option value="{{$item->id}}">{{$item->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Name</label>
                                                            <input type="text" class="form-control" name="name" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        
                                                        <div class="mb-3">
                                                            <label class="form-label">Phone </label>
                                                            <input type="text" name="phone" class="form-control" required oninput="this.value = this.value.replace(/[^0-9]/g, '')" maxlength="12">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Aadhar Number</label>
                                                            <input type="text" name="aadhar_no" required class="form-control">
                                                        </div>
                                                    </div>
                                                    

                                                     <div class="col-12">
                                                        <div class="mb-3">
                                                            <label class="form-label">Address</label>
                                                            <input type="text" name="address" required class="form-control">
                                                         
                                                        </div>
                                                    </div>

                                                    <div class="col-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">License Number</label>
                                                            <input type="text" name="licence_number" required class="form-control">
                                                         
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Licence Expired Date</label>
                                                            <div class="input-group dates">
                                                                <input class="form-control basic-date" required type="text" name="licence_validity">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                                                         
                                                    <div class="col-md-4">
                                                        <div class="mb-3">
                                                            <label class="form-label">Driver Zone</label>
                                                            <select class="form-control" name="zone_id">
                                                                <option value="NULL">---Select Zone---</option>
                                                                @foreach(App\Models\Zone::where('status','ACTIVE')->get() as $item)
                                                                    <option value="{{$item->id}}">{{$item->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>


                                                     <div class="col-md-4">
                                                        <div class="mb-3">
                                                            <label class="form-label">Driver Image <span class="text-secondary f-s-12">(Optional)</span></label>
                                                            <input type="file" class="form-control" name="photo" >
                                                        </div>
                                                    </div>
                                                    
                                                      <div class="col-md-4">
                                                        <div class="mb-3">
                                                            <label class="form-label">Upload Licence <span class="text-secondary f-s-12">(Optional)</span></label>
                                                            <input type="file" accept="image/*" class="form-control" name="licence" >
                                                        </div>
                                                    </div>

                                                    
                                                 
                                                    <div class="col-12 mt-3">
                                                        <div class="text-end">
                                                            <button type="submit" class="btn btn btn-primary">SAVE DRIVER</button>
                                                        </div>
                                                  </div>
                                                </div>
                         </div>
                     </form>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
        </main>
      
   <script type="text/javascript">
     
    </script>
  @endsection
