@extends('layouts.vendor-template')

@section('content')
@php
$data=Auth::guard('vendor-web')->user();
@endphp
<style>
    .table {
        width: 100%;
    }
</style>
<!-- Main Section start -->
<main>

    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12 ">
                <h4 class="main-title">Vendor details</h4>

                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="{{route('home')}}" class="f-s-14 f-w-500">
                            <span>
                                <i class="ph-duotone  ph-stack f-s-16"></i> Home
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="" class="f-s-14 f-w-500">Vendors</a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Vendor Details</a>
                    </li>
                </ul>

                <div style="float:right;    margin-top: -51px;
">
                    <a href="{{route('vendor.edit-profile')}}" class="btn btn-primary btn-lg w-100 "><i class="ti ti-plus"></i> Edit Profile</a>
                </div>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="row ">
                    <div class="col-lg-4 col-xxl-4 col-box-4 order-lg--1">
                        <div class="card">
                            <div class="card-body">
                                <div class="profile-container">
                                    <div class="image-details">
                                        <div class="profile-image" style="background-image:url({{asset('assets/images/team/1.jpg')}});"></div>
                                        <div class="profile-pic">
                                            <div class="avatar-upload">

                                                <div class="avatar-preview">
                                                    <div id="imgPreview" style="background-image:url({{$data->vendor_image}});">

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="person-details">
                                        <h5 class="f-w-600">{{$data->name}}
                                            <img src="{{asset('assets/images/profile-app/01.png')}}" class="w-20 h-20" alt="{{$data->name}}">
                                        </h5>
                                        <p>Vendor</p>
                                        <div class="details">
                                            <div>
                                                <h4 class="text-primary"> {{count(App\Models\BookingHistory::where('vendor_id',$data->id)->get())}}</h4>
                                                <p class="text-secondary">Bookings</p>
                                            </div>
                                            <div>
                                                <h4 class="text-primary">{{count(App\Models\Driver::where('vendor_id',$data->id)->get())}}</h4>
                                                <p class="text-secondary">Drivers</p>
                                            </div>
                                            <div>
                                                <h4 class="text-primary">{{count(App\Models\Vehicle::where('vendor_id',$data->id)->get())}}</h4>
                                                <p class="text-secondary">Vehicles</p>
                                            </div>
                                        </div>
                                        <div class="my-2">
                                            <button type="button" class="btn btn-{{ $data->add_driver_permission == 'ON' ? 'success' : 'secondary' }} b-r-22" id="followButton"> <i class="ti ti-user"></i>
                                                Driver Add permission </button>

                                            <button type="button" class="btn btn-{{ $data->add_driver_permission == 'ON' ? 'warning' : 'secondary' }} b-r-22" id="followButton"> <i class="ti ti-user"></i>
                                                {{ucfirst($data->status)}}</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-xxl-3 col-box-3 order-lg--1">
                        <div class="card">
                            <div class="card-header">
                                <h5>About Me</h5>
                            </div>
                            <div class="card-body">

                                <div class="about-list">
                                    <div>
                                        <span class="fw-medium"><i class="ti ti-briefcase"></i> Name</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->name}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-medium"><i class="ti ti-mail"></i> Email</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->email}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-medium"><i class="ti ti-phone"></i> Contact</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->phone}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-medium"><i class="ti ti-cake"></i>Address</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->address}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-semibold"><i class="ti ti-map-pin"></i> Zone</span>
                                        <span class="float-end f-s-13 text-secondary">{{App\Models\Zone::where('id',$data->zone)->pluck('name')->first()}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-semibold"><i class="ti ti-device-laptop"></i> District</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->district}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-semibold"><i class="ti ti-brand-github"></i> State</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->state}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-semibold"><i class="ti ti-brand-github"></i> Country</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->country}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-semibold"><i class="ti ti-brand-github"></i> Pincode</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->pincode}}</span>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-5 col-xxl-5 col-box-5 order-lg--1">
                        <div class="row ticket-app">
                            <div class="col-sm-6">
                                <div class="card ticket-card bg-primary">
                                    <div class="card-body">
                                        <i class="ph-bold  ph-circle circle-bg-img"></i>
                                        <div class="h-50 w-50 d-flex-center b-r-15 bg-white mb-3">
                                            <i class="ph-bold  ph-ticket f-s-25 text-primary"></i>
                                        </div>
                                        <p class="f-s-16">Upcoming bookings</p>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h3 class="text-white">{{count(App\Models\BookingHistory::where('vendor_id',$data->id)->where('booking_status','Upcoming')->get())}}</h3>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="card ticket-card bg-info">
                                    <div class="card-body">
                                        <i class="ph-bold  ph-circle circle-bg-img"></i>
                                        <div class="h-50 w-50 d-flex-center b-r-15 bg-white mb-3">
                                            <i class="ph-bold  ph-clock-countdown f-s-25 text-info"></i>
                                        </div>
                                        <p class="f-s-16">Confirmed Bookings</p>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h3 class="text-white">{{count(App\Models\BookingHistory::where('vendor_id',$data->id)->where('booking_status','Confirmed')->get())}}</h3>

                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="card ticket-card bg-success">
                                    <div class="card-body">
                                        <i class="ph-bold  ph-circle circle-bg-img"></i>
                                        <div class="h-50 w-50 d-flex-center b-r-15 bg-white mb-3">
                                            <i class="ph-bold  ph-file-cloud f-s-25 text-success"></i>
                                        </div>
                                        <p class="f-s-16">Completed Bookings</p>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h3 class="text-white">{{count(App\Models\BookingHistory::where('vendor_id',$data->id)->where('booking_status','Completed')->get())}}</h3>

                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="card ticket-card bg-warning">
                                    <div class="card-body">
                                        <i class="ph-bold  ph-circle circle-bg-img"></i>
                                        <div class="h-50 w-50 d-flex-center b-r-15 bg-white mb-3">
                                            <i class="ph-bold  ph-file-x f-s-25 text-warning"></i>
                                        </div>
                                        <p class="f-s-16">Canceled Bookings</p>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h3 class="text-white">{{count(App\Models\BookingHistory::where('vendor_id',$data->id)->where('booking_status','Canceled')->get())}}</h3>

                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="tab-wrapper">
                    <ul class="tabs">
                        <li class="tab-link active" data-tab="1"><i class="ph-duotone  ph-pen-nib f-s-18 me-2"></i>Bookings</li>
                        <li class="tab-link" data-tab="2"><i class="ph-duotone  ph-user-circle f-s-18 me-2"></i>Drivers</li>
                        <li class="tab-link" data-tab="3"><i class="ph-duotone  ph-car-simple f-s-18 me-2"></i>Vehicles</li>
                    </ul>
                </div>
                <div class="content-wrapper mt-3">
                    <div id="tab-1" class="tabs-content active">
                        <div class="card">
                            <div class="card-header">
                                <h4>Bookings</h4>
                            </div>
                            <div class="card-header">
                                <h5>Filter Data</h5>
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Start Date</label>
                                            <div class="input-group dates">
                                                <input class="form-control basic-date" type="text" name="start_date" id="start_date">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">End Date </label>
                                            <div class="input-group dates">
                                                <input class="form-control basic-date" type="text" name="end_date" id="end_date">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Status </label>
                                            <select class="form-control " name="status" id="status">
                                                <option value="">All</option>
                                                <option value="Upcoming">Upcoming</option>
                                                <option value="Confirmed">Confirmed</option>
                                                <option value="Running">Running</option>
                                                <option value="Completed">Completed</option>
                                                <option value="Canceled">Canceled</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-3 mt-3">
                                        <div class="mt-2">
                                            <button type="submit" class="btn btn btn-primary filter">Filter </button>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="card-body px-0">
                                <div class=" table-responsive app-scroll app-datatable-default product-list-table">
                                    <table id="product-Listtable" class="table table-sm display align-middle bookings">
                                        <thead>
                                            <tr>
                                                <th>
                                                    #
                                                </th>
                                                <th> BOOKING ID</th>
                                                <th>PICKUP<i class="ph-bold  ph-arrow-down"></i> DROPOFF</th>
                                                <th>DEPARTURE_DATE<i class="ph-bold  ph-arrow-down"></i> DROP_OFF_DATE</th>
                                                <th>TOTAL KM</th>
                                                <th>TOTAL FARE</th>
                                                <th>DRIVER</th>
                                                <th>VEHICLE</th>
                                                <th>BOOKED BY</th>
                                                <th>BOOKING STATUS</th>

                                                <th>PAYMENT STATUS</th>

                                            </tr>
                                        </thead>

                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="tab-2" class="tabs-content">
                        <div class="card">
                            <div class="card-header">
                                <h4>Drivers</h4>
                            </div>
                            <div class="card-body px-0">
                                <div class=" table-responsive app-scroll app-datatable-default product-list-table">
                                    <table id="product-Listtable" class="table table-responsive  drivers">
                                        <thead>
                                            <tr>
                                                <th>
                                                    #
                                                </th>
                                                <th> Name</th>

                                                <th>Phone</th>
                                                <th>Address</th>
                                                <th>License Validity</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>

                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="tab-3" class="tabs-content">
                        <div class="card">
                            <div class="card-header">
                                <h4>Vehicles</h4>
                            </div>
                            <div class="card-body px-0">
                                <div class=" table-responsive app-scroll app-datatable-default product-list-table">
                                    <table id="product-Listtable" class="table table-sm display align-middle vehicles">
                                        <thead>
                                            <tr class="text-center">
                                                <th>
                                                    #
                                                </th>
                                                <th>Vehicle Type</th>
                                                <th> Name</th>

                                                <th>Driver</th>
                                                <th>Seats</th>
                                                <th>Availablity Status</th>
                                                <th>Plate Number</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>

                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>


    </div>
    </div>
    <!-- Product List end -->
    </div>
</main>

<script type="text/javascript">
    $(function() {

        var table = $('.bookings').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('vendor.get-bookings') }}",
                data: function(d) {
                    d.start_date = $('#start_date').val();
                    d.end_date = $('#end_date').val();
                    d.status = $('#status').val();
                    d.vendor_id = <?php echo $data->id; ?>;
                }
            },

            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'booking_id',
                    name: 'booking_id'
                },
                {
                    data: 'location',
                    name: 'location'
                },
                {
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'total_km',
                    name: 'total_km'
                },
                {
                    data: 'total_fare',
                    name: 'total_fare'
                },
                {
                    data: 'driver',
                    name: 'driver'
                },
                {
                    data: 'vehicle',
                    name: 'vehicle'
                },
                {
                    data: 'booked_by',
                    name: 'booked_by'
                },
                {
                    data: 'booking_status',
                    name: 'booking_status'
                },

                {
                    data: 'payment_status',
                    name: 'payment_status'
                },


            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row 
            },
        });

        $(".filter").click(function() {
            table.draw();
        });


        $('.drivers').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('vendor.get-driver') }}",
                data: function(d) {
                    d.vendor_id = <?php echo $data->id; ?>;
                }
            },

            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'name',
                    name: 'name'
                },

                {
                    data: 'phone',
                    name: 'phone'
                },
                {
                    data: 'address',
                    name: 'address'
                },
                {
                    data: 'License Validity',
                    name: 'License Validity'
                },
                {
                    data: 'status',
                    name: 'status'
                },

                {
                    data: 'action',
                    name: 'action'
                },

            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row 
            },
        });


        $('.vehicles').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('vendor.get-vehicle') }}",
                data: function(d) {
                    d.vendor_id = <?php echo $data->id; ?>;
                }
            },

            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'name',
                    name: 'name'
                },

                {
                    data: 'driver',
                    name: 'driver'
                },
                {
                    data: 'seats',
                    name: 'seats'
                },
                {
                    data: 'astatus',
                    name: 'astatus'
                },
                {
                    data: 'plate_number',
                    name: 'plate_number'
                },
                {
                    data: 'status',
                    name: 'status'
                },

                {
                    data: 'action',
                    name: 'action'
                },

            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row 
            },
        });
    });
</script>
@endsection