@extends('layouts.vendor-template')

@section('content')

<!-- Main Section start -->
<main>

    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12 ">
                <h4 class="main-title">Bookings <span class="text-danger mb-0"> (
                        {{count(App\Models\BookingHistory::where('vendor_id',Auth::guard('vendor-web')->user()->id)->get())}}
                        ) </span></h4>

            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Filter Data</h5>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Start Date</label>
                                    <div class="input-group dates">
                                        <input class="form-control basic-date" type="text" name="start_date" id="start_date">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">End Date </label>
                                    <div class="input-group dates">
                                        <input class="form-control basic-date" type="text" name="end_date" id="end_date">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Status </label>
                                    <select class="form-control " name="status" id="status">
                                        <option value="">All</option>
                                        <option value="Upcoming">Upcoming</option>
                                        <option value="Confirmed">Confirmed</option>
                                        <option value="Running">Running</option>
                                        <option value="Completed">Completed</option>
                                        <option value="Canceled">Canceled</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-3 mt-3">
                                <div class="mt-2">
                                    <button type="submit" class="btn btn btn-primary filter">Filter </button>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="card-body px-0">
                        <div class=" table-responsive app-scroll app-datatable-default product-list-table">
                            <table id="product-Listtable" class="table table-sm display align-middle">
                                <thead>
                                    <tr>
                                        <th>
                                            #
                                        </th>
                                        <th> BOOKING ID</th>
                                        <th>PICKUP<i class="ph-bold  ph-arrow-down"></i> DROPOFF</th>
                                        <th>DEPARTURE_DATE<i class="ph-bold  ph-arrow-down"></i> DROP_OFF_DATE</th>
                                        <th>TOTAL KM</th>
                                        <th>TOTAL FARE</th>
                                        <th>DRIVER</th>
                                        <th>VEHICLE</th>
                                        <th>BOOKED BY</th>
                                        <th>BOOKING STATUS</th>

                                        <th>PAYMENT STATUS</th>

                                    </tr>
                                </thead>

                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
</main>

<script type="text/javascript">
    $(function() {

        var table = $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('vendor.get-bookings') }}",
                data: function(d) {
                    d.start_date = $('#start_date').val();
                    d.end_date = $('#end_date').val();
                    d.status = $('#status').val();
                }
            },

            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'booking_id',
                    name: 'booking_id'
                },
                {
                    data: 'location',
                    name: 'location'
                },
                {
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'total_km',
                    name: 'total_km'
                },
                {
                    data: 'total_fare',
                    name: 'total_fare'
                },
                {
                    data: 'driver',
                    name: 'driver'
                },
                {
                    data: 'vehicle',
                    name: 'vehicle'
                },
                {
                    data: 'booked_by',
                    name: 'booked_by'
                },
                {
                    data: 'booking_status',
                    name: 'booking_status'
                },

                {
                    data: 'payment_status',
                    name: 'payment_status'
                },

            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row 
            },
        });

        $(".filter").click(function() {
            table.draw();
        });
    });
</script>
@endsection