@extends('layouts.login-template')

@section('content')
<style>
  .form_container {
    width: 100%;
    padding: 15px;
    margin: 0 auto;
}

@media (min-width: 992px) {
    .form_container {
        width: 800px !important;
    }
}

</style>
<div class="app-wrapper d-block">
    <div class="">
        <!-- Body main section starts -->
        <main class="w-100 p-0">
            <!-- Login to your Account start -->
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12 p-0">
                        <div class="login-form-container" style="background-image:url('{{ asset('build/assets/vendor-bg.webp') }}');">
                            <div class="mb-4">
                                <a class="logo" href="/">
                                    <img alt="#" src="{{ asset('assets/images/logo/3.png') }}" class="" style="width:100%;">
                                </a>
                            </div>

                            
                            <div class="form_container">

                                <div class=" mb-3 mt-3 text-center">
                                    <p>More information. Please complete your profile. </p>
                                </div>

                                <!-- Show Validation Errors -->
                                @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul class="mb-0">
                                        @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                                @endif

                                <form method="POST" action="{{ route('vendor.update-new-vendor') }}" class="app-form" enctype="multipart/form-data">
                                    @csrf

                                    <div class="row">

                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">Name</label>
                                                <input type="text" class="form-control" name="name" value="{{ old('name', $data->name) }}" required>
                                            </div>
                                        </div>

                                        <div class="col-6">
                                            <div class="mb-3">
                                                <label class="form-label">Email address</label>
                                                <input type="email" name="email" class="form-control" value="{{ old('email', $data->email) }}" required>
                                            </div>
                                        </div>

                                        <div class="col-6">
                                            <div class="mb-3">
                                                <label class="form-label">Address</label>
                                                <input type="text" name="address" class="form-control" value="{{ old('address', $data->address) }}" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">Driver Zone</label>
                                                <select class="form-control" name="zone_id" required>
                                                    <option value="">---Select Zone---</option>
                                                    @foreach(App\Models\Zone::where('status', 'ACTIVE')->get() as $item)
                                                    <option value="{{ $item->id }}" {{ old('zone_id', $data->zone_id) == $item->id ? 'selected' : '' }}>
                                                        {{ $item->name }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">District</label>
                                                <input type="text" name="district" class="form-control" value="{{ old('district', $data->district) }}">
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">State</label>
                                                <input type="text" class="form-control" name="state" value="{{ old('state', $data->state) }}" required>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">Country</label>
                                                <input type="text" class="form-control" name="country" value="{{ old('country', $data->country) }}" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">Postal Code</label>
                                                <input type="hidden" name="id" value="{{ $data->id }}">
                                                <input type="text" class="form-control" name="postal_code" value="{{ old('postal_code', $data->postal_code) }}" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">Vendor Image (.jpg, .jpeg, .png) </label>
                                                <input type="file" class="form-control" name="photo" accept=".jpg, .jpeg, .png"  required onchange="showImagePreview(this, 'photoPreview')">
                                                <img id="photoPreview" src="{{ asset('uploads/driver/' . $data->image) }}" class="w-150 rounded mt-2" alt="">
                                            </div>
                                        </div>

                                        <div class="col-12 mt-3">
                                            <div class="text-end">
                                                     <a href="{{route('index')}}"  class="btn btn-secondary">Return to Home</a>
                                                <button type="submit" class="btn btn-primary">UPDATE VENDOR</button>
                                            </div>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
        <!-- Body main section ends -->
    </div>
</div>
@endsection