@extends('layouts.vendor-template')

@section('content')

<!-- Main Section start -->
<main>

    <div class="container-fluid">

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Add Trip Lifecycle for Booking Id : <a href="{{route('vendor.get-booking-details', ['id' => $data->booking_id])}}" class="text-primary">{{$data->booking_id}}</a></h4>

                    </div>
                    @php
                    $raw = $data->stay_date; // The double-encoded JSON string

                    $firstDecode = json_decode($raw, true); // returns a JSON string
                    $dates = json_decode($firstDecode, true); // returns the actual PHP array

                    $existing = $existingLifeCycles ?? collect();
                    @endphp
                    <div class="card-body px-5">
                        <form action="{{route('save-trip-lifecycle')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <ul class="app-timeline-box">
                                    @for($i = 0; $i < count($dates); $i++)
                                        @php
                                        $dateString=\Carbon\Carbon::parse($dates[$i])->format('Y-m-d');
                                        $lifecycle = $existing->get($dateString);
                                        @endphp

                                        <li class="timeline-section">
                                            <div class="timeline-icon">
                                                <span class="text-light-primary h-55 w-55 d-flex-center b-r-50">
                                                    Day {{$i+1}}
                                                     
                                                </span>
                                              
                                            </div>
                                            <div class="timeline-content pt-0">
                                                <div class="d-block f-s-16">
                                                    <p class="text-info f-s-18 mb-0">{{$dates[$i]}}   <span class="badge text-outline-danger f-s-16 mb-0">Actual KM: {{$lifecycle->actual_km}}</span></p>
                                                    <div class="row app-timeline-info-text timeline-border-box me-2 ms-0 mt-3 p-3">
                                                        <div class="col-md-3">
                                                            <div class="mb-3">
                                                              <input type="hidden" name="bookingid" value="{{$data->id}}">
                                                                <input type="hidden" name="tripid[]" value="{{$lifecycle->id}}">
                                                                <input type="hidden" name="remainingKM" value="{{$data->remainingKM}}">
                                                                <input type="hidden" name="day[]" value="Day {{$i+1}}">
                                                                <input type="hidden" name="trip_date[]" value="{{$dates[$i]}}">
                                                                <label class="form-label">Starting meter Reading</label>
                                                                <input type="text" name="starting_meter_reading[]" class="form-control" value="{{ $lifecycle->starting_meter_reading ?? '' }}">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="mb-3">
                                                                <label class="form-label">Ending meter Reading</label>
                                                                <input type="text" name="ending_meter_reading[]" class="form-control" value="{{ $lifecycle->ending_meter_reading ?? '' }}">
                                                            </div>
                                                        </div>
                                                        <div class="col-3">
                                                            <div class="mb-3">
                                                                <label class="form-label">Additional Charge Collected</label>
                                                                <input type="text" name="additional_charge_collected[]" class="form-control" value="{{ $lifecycle->additional_charge_collected ?? '' }}">
                                                            </div>
                                                        </div>
                                                         <div class="col-3">
                                                            <div class="mb-3">
                                                                <label class="form-label">Amount Collected</label>
                                                                <input type="text" name="amount_collected[]" class="form-control" value="{{ $lifecycle->amount_collected ?? '' }}">
                                                            </div>
                                                        </div>
                                                        <div class="col-12">
                                                            <div class="mb-3">
                                                                <label class="form-label">Note</label>
                                                                <textarea name="note[]" class="form-control">{{ $lifecycle->note ?? '' }}</textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        @endfor


                                </ul>

                                <div class="col-12 mt-3">
                                    <div class="text-end">
                                        <button type="submit" class="btn btn btn-primary">SAVE </button>
                                    </div>
                                </div>
                            </div>


                    </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
</main>

@endsection