@extends('layouts.login-template')

@section('content')
<div class="app-wrapper d-block">
    <div class="">
        <!-- Body main section starts -->
        <main class="w-100 p-0">
            <!-- Login to your Account start -->
            <div class="container-fluid">
                <div class="row">

                    <div class="col-12 p-0">
                        <div class="login-form-container" style="background-image:url('{{asset('build/assets/vendor-bg.webp')}}');">
                            <div class="mb-4">
                                <a class="logo" href="/">
                                    <img alt="#" src="{{asset('assets/images/logo/3.png')}}" class="" style="width:100%;">
                                </a>
                            </div>
                            <div class="form_container">
                                <form method="POST" action="{{ route('driver.verify-otp') }}" class="app-form " id="otpForm">
                                  @csrf
                               
                                    <div class="mb-3 text-center">
                                        <h3>Verify your Account</h3>
                                      <p>Enter the 5 digit code sent to the registered mobile number</p>
                                    </div>
                                      <div class="verification-box">
                                                <div>
                                                    <input type="hidden" name="phone" value="{{$phone}}">
                                                     <input type="hidden" name="otp" id="otpField" />
                                                    <input class="form-control h-60 w-60 text-center otp-input" id="one"
                                                           maxlength="1"
                                                           oninput='digitValidate(this)' onkeyup='tabChange(1)'
                                                           type="text">
                                                </div>
                                                <div>
                                                    <input class="form-control h-60 w-60 text-center otp-input" id="two"
                                                           maxlength="1"
                                                           oninput='digitValidate(this)' onkeyup='tabChange(2)'
                                                           type="text">
                                                </div>
                                                <div>
                                                    <input class="form-control h-60 w-60 text-center otp-input" id="three"
                                                           maxlength="1"
                                                           oninput='digitValidate(this)' onkeyup='tabChange(3)'
                                                           type="text">
                                                </div>
                                                <div>
                                                    <input class="form-control h-60 w-60 text-center otp-input" id="four"
                                                           maxlength="1"
                                                           oninput='digitValidate(this)' onkeyup='tabChange(4)'
                                                           type="text">
                                                </div>
                                                 <div>
                                                    <input class="form-control h-60 w-60 text-center otp-input" id="five"
                                                           maxlength="1"
                                                           oninput='digitValidate(this)' onkeyup='tabChange(5)'
                                                           type="text">
                                                </div>
                                            </div>
                                    
                                    
                                    <div>
                                           <button type="submit" class="btn btn-primary w-100">
                                Verify
                                </button>
                                        
                                    </div>
                                  
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Login to your Account end -->
        </main>
        <!-- Body main section ends -->
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const inputs = document.querySelectorAll('.otp-input');

    inputs.forEach((input, index) => {
        input.addEventListener('input', (e) => {
            const value = e.target.value;
            if (!/^\d$/.test(value)) {
                e.target.value = '';
                return;
            }

            // Move to next
            if (value && index < inputs.length - 1) {
                inputs[index + 1].focus();
            }
        });

        input.addEventListener('keydown', (e) => {
            if (e.key === 'Backspace' && !e.target.value && index > 0) {
                inputs[index - 1].focus();
            }
        });
    });

    // Combine OTP on submit
    document.getElementById('otpForm').addEventListener('submit', function(e) {
        e.preventDefault();

        let otpValue = '';
        inputs.forEach(input => {
            otpValue += input.value;
        });

        document.getElementById('otpField').value = otpValue;

        this.submit();
    });
});
</script>

<script>

document.getElementById('otpForm').addEventListener('submit', function(e) {
    e.preventDefault();

    // Get all OTP inputs
    const otpInputs = document.querySelectorAll('.otp-input');
    let otpValue = '';

    otpInputs.forEach(input => {
        otpValue += input.value;
    });

    // Set hidden field value
    document.getElementById('otpField').value = otpValue;

    // Now actually submit the form
    this.submit();
});
</script>

@endsection
