@extends('layouts.driver-template')

@section('content')

        <!-- Main Section start -->
  <main>
            
     <div class="container-fluid">
        <div class="row">
            <div class="col-sm-8 col-lg-8 col-xxl-8 eshop-cards-container">
                <div class="row">
                    <div class="col-4 col-md-4 col-lg-4">
                        <div class="card">
                            <span class="bg-danger h-50 w-50 d-flex-center rounded-circle m-auto eshop-icon-box">
                         <i class="ph-fill  ph-money" style="font-size: 22px;"></i>
                            </span>


                            <div class="card-body eshop-cards">
                                <span class="ripple-effect"></span>
                                <div class="overflow-hidden">
                                    <h3 class="text-danger mb-0">
                                        {{count(App\Models\BookingHistory::where('driver_id',Auth::guard('driver-web')->user()->id)->get())}}
                                    </h3>
                                    <p class="mg-b-35 f-w-600 text-dark-800 txt-ellipsis-1">Total Bookings</p>
                                    <span class="badge bg-light-danger">View Bookings</span>
                                </div>
                            </div>
                        </div>
                    </div>
                      <div class="col-4 col-md-4 col-lg-4">
                            <div class="card">
                                <span class="bg-primary h-50 w-50 d-flex-center rounded-circle m-auto eshop-icon-box">
                                      <i class="ph-fill  ph-user" style="font-size: 22px;"></i>
                                </span>


                                <div class="card-body eshop-cards">
                                    <span class="ripple-effect"></span>
                                    <div class="overflow-hidden">
                                        <h3 class="text-primary mb-0">
                                            {{count(App\Models\Driver::where('driver_id',Auth::guard('driver-web')->user()->id)->get())}}
                                        </h3>
                                        <p class="mg-b-35 f-w-600 text-dark-800 txt-ellipsis-1">Total Drivers</p>
                                        <span class="badge bg-light-primary">View Drivers</span>
                                    </div>
                                </div>
                            </div>
                     </div>

                        <div class="col-4 col-md-4 col-lg-4">
                                <div class="card">
                                    <span class="bg-danger h-50 w-50 d-flex-center rounded-circle m-auto eshop-icon-box">
                                        <i class="ph-fill  ph-car" style="font-size: 22px;"></i>
                                    </span>


                                    <div class="card-body eshop-cards">
                                        <span class="ripple-effect"></span>
                                        <div class="overflow-hidden">
                                            <h3 class="text-danger mb-0">
                                            {{count(App\Models\Vehicle::where('driver_id',Auth::guard('driver-web')->user()->id)->get())}}
                                            </h3>
                                            <p class="mg-b-35 f-w-600 text-dark-800 txt-ellipsis-1">Total Vehicles</p>
                                            <span class="badge bg-light-danger">View Vehicles</span>
                                        </div>
                                    </div>
                                </div>
                       </div>
                </div>
             </div>
          
             
             <div class="col-sm-4 col-lg-4 col-xxl-4 ">
                <ul class="notifications-list box-list mb-4 ">
                    <li class="d-flex align-items-center justify-content-between gap-3 b-s-4-primary">
                        <div>
                            <h6 class="txt-ellipsis-1 mb-0"> Latest Bookings</h6>
                            <!-- <p class="text-secondary mb-0">Last 2H Updates</p> -->
                        </div>
                        <div class="h-45 w-45 d-flex-center rounded-circle flex-shrink-0 bg-light-primary position-relative">
                            <i class="ph ph-bell-ringing f-s-20"></i>
                            <span class="position-absolute translate-middle badge rounded-pill bg-danger badge-notification">4</span>
                        </div>
                    </li>
                    @foreach(App\Models\BookingHistory::where('driver_id',Auth::guard('driver-web')->user()->id)->limit(5)->get() as $item)
                    @php 
                    $departure = Carbon\Carbon::parse($item->departure_date);
                        $return = Carbon\Carbon::parse($item->return_date);

                        // Total days (inclusive)
                        $totalDays = $departure->diffInDays($return) + 1; // +1 to include both start and end dates
                        $nightCount = $totalDays - 1;

                        // Final title
                        $tripTitle = "{$nightCount}NIGHTS {$totalDays}DAYS";
                    @endphp
                    <li class="d-flex align-items-center">
                        <div class="h-45 w-45 d-flex-center b-r-12 overflow-hidden flex-shrink-0 bg-primary">
                            OR
                        </div>
                        <div class="ms-3">
                            <p class="mb-0 f-w-500 f-s-16 txt-ellipsis-1">{{$tripTitle}} - {{ $item->booking_id}}</p>
                            <p class="mb-0 text-secondary">{{$item->created_at}}</p>
                        </div>
                    </li>
                    @endforeach
                  
                </ul>
            </div>

        
    </div>
  </main>
      
@endsection
