@extends('layouts.template')

@section('content')

<!-- Main Section start -->
<main>

    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12 ">
                <h4 class="main-title">Vehicles List</h4>
                @can('vehicles')
                <div style="float:right;    margin-top: -51px;">
                    <a href="{{route('add-vehicle')}}" class="btn btn-primary btn-lg w-100 "><i class="ti ti-plus"></i> Add Vehicle</a>
                </div>
                @endcan

            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-body px-0">
                        <div class=" table-responsive app-scroll app-datatable-default product-list-table">
                            <table id="product-Listtable" class="table table-sm display align-middle">
                                <thead>
                                    <tr class="text-center">
                                        <th>
                                            #
                                        </th>
                                        <th>Vehicle Type</th>
                                        <th> Name</th>

                                        <th>Vendor</th>
                                        <th>Driver</th>
                                        <th>Seats</th>
                                        <th>Availablity Status</th>
                                        <th>Plate Number</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>

                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
</main>

<script type="text/javascript">
    $(function() {

        $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-vehicle') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'vendor',
                    name: 'vendor'
                },
                {
                    data: 'driver',
                    name: 'driver'
                },
                {
                    data: 'seats',
                    name: 'seats'
                },
                {
                    data: 'astatus',
                    name: 'astatus'
                },
                {
                    data: 'plate_number',
                    name: 'plate_number'
                },
                {
                    data: 'status',
                    name: 'status'
                },

                {
                    data: 'action',
                    name: 'action'
                },

            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row 
            },
        });
    });
</script>
@endsection