@extends('layouts.template')

@section('content')

        <!-- Main Section start -->
        <main>
            
     <div class="container-fluid">

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                    <h4>Add vehicle</h4>
                </div>
                    <div class="card-body px-5">
                         <form action="{{route('save-vehicle')}}" method="post" enctype="multipart/form-data">
                                @csrf
                         <div class="row">
                                                 <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Driver</label>
                                                            <select class="form-control" required name="driver_id">
                                                                <option value="">---Select Driver---</option>
                                                                @foreach(App\Models\Driver::where('status','ACTIVE')->get() as $item)
                                                                    <option value="{{$item->id}}">{{$item->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                     <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Vehicle Modal</label>
                                                            <select class="form-control" name="brand" required>
                                                                <option value="">---Select brand---</option>
                                                                @foreach(App\Models\BrandVehicle::get() as $item)
                                                                    <option value="{{$item->id}}">{{App\Models\Brand::where('id',$item->brand)->pluck('name')->first()}} -{{$item->model_name}} </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                 
                                                    <div class="col-md-6">
                                                        <div class="mb-3 floating-select">
                                                            <label class="form-label">Vehicle Make</label>
                                                            <input type="text" class="form-control" required name="vehicle_make">
                                                    </div>
                                                </div>
                                                        <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Year of registration</label>
                                                            <input type="number" name="year_of_registration" required class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Number of Passengers seats</label>
                                                            <input type="number" name="seats" required class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Color</label>
                                                            <div class="input-group">
                                                                <input class="form-control" required type="text" name="color">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Fuel Type</label>
                                                            <select class="form-control" name="fuel_type" required>
                                                                <option value="Petrol">Petrol</option>
                                                               <option value="Diesel">Diesel</option>
                                                                <option value="CNG">CNG</option>
                                                               <option value="Electric">Electric</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    
                                        
                                                <div class="col-md-6">
                                                        <div class="mb-3 floating-select">
                                                            <label class="form-label">Plate Number</label>
                                                            <input type="text" class="form-control" required name="plate_number">
                                                        </div>
                                                    </div>


                                                     <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Registration validity</label>
                                                            <div class="input-group dates">
                                                                <input class="form-control basic-date" required type="text" name="reg_validity">
                                                            </div>
                                                        </div>
                                                    </div>

                                                     <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Insurance Validity</label>
                                                            <div class="input-group dates">
                                                                <input class="form-control basic-date" required type="text" name="insurance_validity">
                                                            </div>
                                                        </div>
                                                    </div>

                                                     <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Tax Validity</label>
                                                            <div class="input-group dates">
                                                                <input class="form-control basic-date" required type="text" name="tax_validity">
                                                            </div>
                                                        </div>
                                                    </div>
                                                     <div class="col-md-6">
                                                        <div class="mb-3 file-uploader-box">
                                                            <label class="form-label" >Image</label>
                                                            <!-- <input type="file" name="csv[]" class="filepond" multiple/> -->

                                                            <input type="file"  class="form-control filepond|"   required name="images[]" multiple/>
                                                       
                                                       

                                                        </div>
                                                    </div>
                                                    
                                                   
                                                    <div class="col-12 mt-3">
                                                        <div class="text-end">
                                                            <button type="submit" class="btn btn btn-primary">SAVE</button>
                                                        </div>
                                                  </div>
                                                </div>
                    </div>
                     </form>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
        </main>
      
   <script type="text/javascript">
     
    </script>
  @endsection
