<!DOCTYPE html>
<html>
<head>
    <title>Route Planner</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        #map { height: 500px; width: 100%; margin-top: 15px; }
        .form-group { margin: 10px 0; }
    </style>
</head>
<body>

<h2>Select Route</h2>

<div class="form-group">
    <input id="start-location" type="text" placeholder="Start Location">
</div>
<div class="form-group">
    <input id="end-location" type="text" placeholder="End Location">
</div>

<div id="waypoints">
    <div class="form-group">
        <input class="waypoint" type="text" placeholder="Waypoint 1">
    </div>
</div>
<button onclick="addWaypoint()">+ Add Waypoint</button>
<br><br>
<select id="vehicle_type">
    @foreach(App\Models\VehicleCategory::where('status','ACTIVE')->get() as $item)
                                                                    <option value="{{$item->id}}">{{$item->name}}</option>
                                                                @endforeach
</select>
<button onclick="calculateRoute()">Calculate Route</button>

<p id="total-distance"></p>
<p id="fare"></p>
<div id="map"></div>

<script>
    let map, directionsService, directionsRenderer;

    function initMap() {
        map = new google.maps.Map(document.getElementById("map"), {
            center: { lat: 10.8505, lng: 76.2711 },
            zoom: 7
        });

        directionsService = new google.maps.DirectionsService();
        directionsRenderer = new google.maps.DirectionsRenderer({ map: map });

        new google.maps.places.Autocomplete(document.getElementById("start-location"));
        new google.maps.places.Autocomplete(document.getElementById("end-location"));
        document.querySelectorAll(".waypoint").forEach(input => {
            new google.maps.places.Autocomplete(input);
        });
    }

    function addWaypoint() {
        const container = document.createElement("div");
        container.className = "form-group";
        container.innerHTML = '<input class="waypoint" type="text" placeholder="Waypoint">';
        document.getElementById("waypoints").appendChild(container);
        new google.maps.places.Autocomplete(container.querySelector("input"));
    }

    function calculateRoute() {
        const origin = document.getElementById("start-location").value;
        const destination = document.getElementById("end-location").value;
        const vehicleType = document.getElementById("vehicle_type").value;

        let waypoints = [];
        document.querySelectorAll(".waypoint").forEach(input => {
            if (input.value) {
                waypoints.push({ location: input.value, stopover: true });
            }
        });

        directionsService.route({
            origin: origin,
            destination: destination,
            waypoints: waypoints,
            travelMode: google.maps.TravelMode.DRIVING
        }, function (response, status) {
            if (status === google.maps.DirectionsStatus.OK) {
                directionsRenderer.setDirections(response);
                const route = response.routes[0];
                let total = 0;
                route.legs.forEach(leg => {
                    total += leg.distance.value; // meters
                });
                const km = (total / 1000).toFixed(2);
                document.getElementById("total-distance").innerText = `Total Distance: ${km} km`;

                // Send to Laravel for fare calculation
                fetch("{{ url('/calculate-fare') }}", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                        "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute("content")
                    },
                    body: JSON.stringify({
                        start: origin,
                        end: destination,
                        waypoints: waypoints.map(wp => wp.location),
                        distance: km,
                        vehicle_type: vehicleType
                    })
                }).then(res => res.json())
                  .then(data => {
                      document.getElementById("fare").innerText = `Total Fare: ₹${data.fare}`;
                  });
            } else {
                alert("Could not calculate route: " + status);
            }
        });
    }
</script>

<script
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyABfBAX-v_a_99NqGylrBuo1mKPnZHx_Go&libraries=places&callback=initMap"
    async defer></script>

</body>
</html>
