@extends('layouts.template')

@section('content')
@php
$lastSegment = Illuminate\Support\Facades\Request::segment(count(Request::segments()));
if($lastSegment=='customers')
$role='Customer';
elseif($lastSegment=='partners')
$role='Partner';

@endphp
<!-- Main Section start -->
<main>

    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12 ">
                <h4 class="main-title">{{$lastSegment }}</h4>
                @can('add-partner')
                <div style="float:right;    margin-top: -51px;">
                    <button type="button" class="btn btn-primary btn-lg w-100 " data-bs-toggle="modal"
                        data-bs-target="#exampleModal"><i class="ti ti-plus"></i> Add {{$role}}</button>
                </div>
                <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">


                    <form action="{{route('add-partner')}}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-dialog modal-dialog-centered modal-xl" id="staticBackdrop">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h1 class="modal-title f-w-500 fs-5" id="exampleModalLabel1"> Add {{$role}}</h1>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body app-form">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">Name</label>
                                                <input type="hidden" class="form-control" name="role" value="{{$role}}">
                                                <input type="text" class="form-control" name="name" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">

                                            <div class="mb-3">
                                                <label class="form-label">Phone </label>
                                                <input type="text" required name="phone" class="form-control"
                                                    oninput="this.value = this.value.replace(/[^0-9]/g, '')"
                                                    maxlength="12">
                                            </div>
                                        </div>

                                        <div class="col-6">
                                            <div class="mb-3">
                                                <label class="form-label">Email address</label>
                                                <input type="email" name="email" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">Image</label>
                                                <input type="file" class="form-control" name="photo">
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label class="form-label">Address</label>
                                                <input type="text" name="address" class="form-control">

                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label class="form-label">District</label>
                                                <input type="text" name="district" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label class="form-label">State</label>
                                                <div class="input-group">
                                                    <input class="form-control" type="text" name="state">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label class="form-label">Country</label>
                                                <input type="text" class="form-control" name="country">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="mb-3 floating-select">
                                                <label class="form-label">Postal Code</label>
                                                <input type="text" class="form-control" name="postal_code">
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">Agency Name</label>
                                                <input type="text" name="agency_name" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">Agency GST Number</label>
                                                <div class="input-group">
                                                    <input class="form-control" type="text" name="agency_gst_number">
                                                </div>
                                            </div>
                                        </div>



                                    </div>


                                </div>





                                <div class="modal-footer">
                                    <button class="btn btn-primary" type="submit" id="push" data-bs-dismiss="modal">Save
                                        changes</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                @endcan

            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-body px-0">
                        <div class=" table-responsive app-scroll app-datatable-default product-list-table">
                            <table id="product-Listtable" class="table table-sm display align-middle">
                                <thead>
                                    <tr>
                                        <th>
                                            #
                                        </th>
                                        <th> Name</th>
                                        <th>Phone</th>
                                        <th>Role change request</th>
                                        <th>Email</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>

                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
</main>

<script type="text/javascript">
$(function() {

    $('.table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('get-partner') }}",
            data: function(d) {
                d.role = "{{ $role }}";
            }
        },
        //  ajax: "{{ route('get-partner') }}",
        columns: [{
                data: 'DT_RowIndex',
                name: 'DT_RowIndex'
            },
            {
                data: 'name',
                name: 'name'
            },
            {
                data: 'phone',
                name: 'phone'
            },
            {
                data: 'role_change_request',
                name: 'role_change_request'
            },
            {
                data: 'email',
                name: 'email'
            },
            {
                data: 'status',
                name: 'status'
            },

            {
                data: 'action',
                name: 'action'
            },

        ],
        "select": {
            'style': 'multi',
            'selector': 'td:first-child' //only checkbox can select row 
        },
    });
});
</script>
@endsection