<!DOCTYPE html>
<html lang="en">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />


<head>
    <!-- All meta and title start-->
    <meta content="text/html; charset=UTF-8" http-equiv="Content-Type">
    <meta content="IE=edge" http-equiv="X-UA-Compatible">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Rido travels likely refers to Rapido, a bike-taxi, auto, and cab aggregator app. Rapido provides a range of ride options, including Bike-Taxi, Auto, and Cab, and also offers services like Bike Lite, Bike Metro, Parcel, Auto share, Auto Pet, and Auto Parcel. Rapido also integrates with metro systems, offering services like Bike Metro to and from certain metro stations">
    <meta content="rido travels, cab booking, travel booking, tour packages">
    <meta content="la-themes" name="author">

    <link rel="icon" href="{{asset('assets/images/logo/3.png')}}" type="image/x-icon">
    <link rel="shortcut icon" href="{{asset('assets/images/logo/3.png')}}" type="image/x-icon">

    <title>Rido Travels</title>
    <!-- meta and title end-->

    <!-- css start !-->
    <!-- Animation css -->
    <link rel="stylesheet" href="{{asset('assets/vendor/animation/animate.min.css')}}">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/" rel="preconnect">
    <link crossorigin href="https://fonts.gstatic.com/" rel="preconnect">
    <link href="https://fonts.googleapis.com/css2?family=Rubik:ital,wght@0,300..900;1,300..900&amp;display=swap"
        rel="stylesheet">

    <!--Flag Icon css-->
    <link rel="stylesheet" type="text/css" href="{{asset('assets/vendor/flag-icons-master/flag-icon.css')}}">

    <!-- Tabler icons-->
    <link rel="stylesheet" type="text/css" href="{{asset('assets/vendor/tabler-icons/tabler-icons.css')}}">

    <!-- Prism css-->
    <link rel="stylesheet" type="text/css" href="{{asset('assets/vendor/prism/prism.min.css')}}">

    <!-- Bootstrap css-->
    <link rel="stylesheet" type="text/css" href="{{asset('assets/vendor/bootstrap/bootstrap.min.css')}}">

    <!-- Simplebar css-->
    <link rel="stylesheet" type="text/css" href="{{asset('assets/vendor/simplebar/simplebar.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/vendor/datepikar/flatpickr.min.css')}}">

    <!-- apexcharts css -->
    <link rel="stylesheet" type="text/css" href="{{asset('assets/vendor/apexcharts/apexcharts.css')}}">

    <!-- glight css -->
    <link rel="stylesheet" href="{{asset('assets/vendor/glightbox/glightbox.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/vendor/datatable/jquery.dataTables.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/vendor/datatable/datatable2/buttons.dataTables.min.css')}}">


    <link rel="stylesheet" href="{{asset('assets/vendor/filepond/filepond.css')}}">
    <link rel="stylesheet" href="{{asset('assets/vendor/filepond/image-preview.min.css')}}">

    <link rel="preload" as="style" href="{{asset('build/assets/style-Cuxwy5N_.css')}}" />
    <link rel="stylesheet" href="{{asset('build/assets/style-Cuxwy5N_.css')}}" /><!-- css end !-->
    <script src="{{asset('assets/js/jquery-3.6.3.min.js')}}"></script>
    <link rel="stylesheet" type="text/css" href="{{asset('assets/vendor/select/select2.min.css')}}">

    <script src="{{asset('assets/vendor/datatable/jquery.dataTables.min.js')}}"></script>
    <!-- <script src="https://cdn.datatables.net/1.11.4/js/dataTables.bootstrap5.min.js"></script> -->
    <!-- slick css -->
    <link rel="stylesheet" href="{{asset('assets/vendor/slick/slick.css')}}">
    <link rel="stylesheet" href="{{asset('assets/vendor/slick/slick-theme.css')}}">
</head>

<body>
    <!-- Loader start-->
    <div class="app-wrapper">
        <!-- Loader start-->
        <div class="loader-wrapper">
            <div class="loader_24"></div>
        </div>
        <!-- Loader end-->

        <!-- Menu Navigation start -->
        <!-- Menu Navigation starts -->
        <nav>
            <div class="app-logo">
                <a class="logo d-inline-block" href="{{route('home')}}">
                    <img alt="#" src="{{asset('assets/images/logo/3.png')}}">
                </a>

                <span class="bg-light-primary toggle-semi-nav d-flex-center">
                    <i class="ti ti-chevron-right"></i>
                </span>

                <div class="d-flex align-items-center nav-profile p-3">
                    <span class="h-45 w-45 d-flex-center b-r-10 position-relative bg-danger m-auto">
                        <img alt="avatar" class="img-fluid b-r-10" src="{{asset('assets/images/avatar/08.png')}}">
                        <span class="position-absolute top-0 end-0 p-1 bg-success border border-light rounded-circle"></span>
                    </span>
                    <div class="flex-grow-1 ps-2">
                        <h6 class="text-primary mb-0">{{auth()->user()->name}}</h6>
                        <p class="text-muted f-s-12 mb-0">{{auth()->user()->getRoleNames()->first()}}</p>
                    </div>


                    <div class="dropdown profile-menu-dropdown">
                        <a aria-expanded="false" data-bs-auto-close="true" data-bs-placement="top" data-bs-toggle="dropdown"
                            role="button">
                            <i class="ti ti-settings fs-5"></i>
                        </a>
                        <ul class="dropdown-menu">
                            <li class="dropdown-item">
                                <a class="f-w-500" href="profile.html" target="_blank">
                                    <i class="ph-duotone  ph-user-circle pe-1 f-s-20"></i> Profile Details
                                </a>
                            </li>
                            <li class="dropdown-item">
                                <a class="f-w-500" href="setting.html" target="_blank">
                                    <i class="ph-duotone  ph-gear pe-1 f-s-20"></i> Settings
                                </a>
                            </li>
                            <!-- <li class="dropdown-item">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <a class="f-w-500" href="#">
                                    <i class="ph-duotone  ph-detective pe-1 f-s-20"></i> Incognito
                                </a>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="form-check form-switch">
                                    <input class="form-check-input form-check-primary" id="incognitoSwitch"
                                           type="checkbox">
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="dropdown-item">
                        <a class="mb-0 text-secondary f-w-500" href="sign_up.html" target="_blank">
                            <i class="ph-bold  ph-plus pe-1 f-s-20"></i> Add account
                        </a>
                    </li> -->

                            <li class="app-divider-v dotted py-1"></li>

                            <li class="dropdown-item">
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button type="submit" class="btn btn-link mb-0 text-danger"><i class="ph-duotone  ph-sign-out pe-1 f-s-20"></i> Log Out</button>
                                </form>

                            </li>
                        </ul>
                    </div>

                </div>
            </div>
            <div class="app-nav" id="app-simple-bar">
                <ul class="main-nav p-0 mt-2">
                    <li class="menu-title">
                        <span>Dashboard</span>
                    </li>
                    @can('home')
                    <li class="no-sub">
                        <a href="{{route('home')}}">
                            <i class="ph-bold  ph-house"></i>
                            &nbsp; Dashboard
                        </a>
                    </li>
                    @endcan
                    @can('bookings')
                    <li class="no-sub">
                        <a href="{{route('bookings')}}">
                            <i class="ph-bold ph-ticket"></i>
                            &nbsp; Bookings
                            <span class="badge bg-danger  badge-dashboard badge-notification ms-2">New
                                {{count(App\Models\BookingHistory::where('booking_status','Upcoming')->get())}}
                            </span>
                        </a>

                    </li>
                    @endcan
                    @can('zones')
                    <li class="no-sub">
                        <a href="{{route('zones')}}">
                            <i class="ph-bold ph-map-pin"></i>
                            &nbsp; Zones
                        </a>
                    </li>
                    @endcan
                    @can('vehicleCategory')
                    <li class="no-sub">
                        <a href="{{route('vehicleCategory')}}">
                            <i class="ph-bold ph-car"></i>
                            &nbsp; Vehicle Category
                        </a>
                    </li>
                    @endcan
                    @can('brands')
                    <li class="no-sub">
                        <a href="{{route('brands')}}">
                            <i class="ph-fill  ph-car-profile"></i>
                            &nbsp; Brands / Models
                        </a>
                    </li>
                    @endcan
                    @can('vehicles')
                    <li class="no-sub">
                        <a href="{{route('vehicles')}}">
                            <i class="ph-fill  ph-car-profile"></i>
                            &nbsp; Vehicles
                        </a>
                    </li>
                    @endcan
                    @can('admin-vendors-list')
                    <li class="no-sub">
                        <a href="{{route('admin-vendors-list')}}">
                            <i class="ph-bold ph-user"></i>
                            &nbsp; Vendors
                        </a>
                    </li>
                    @endcan
                    @can('drivers')
                    <li class="no-sub">
                        <a href="{{route('drivers')}}">
                            <i class="ph-bold  ph-users-four"></i>
                            &nbsp; Drivers
                        </a>
                    </li>
                    @endcan
                    @can('partners')

                    <li class="no-sub">
                        <a href="{{route('partners')}}">
                            <i class="ph-bold  ph-user-circle-gear"></i>
                            &nbsp; Partners
                        </a>
                    </li>
                    @endcan
                    @can('customers')
                    <li class="no-sub">
                        <a href="{{route('customers')}}">
                            <i class="ph-bold  ph-user-circle-gear"></i>
                            &nbsp; Customers
                        </a>
                    </li>

                    @endcan
                    @can('fare')
                    <li class="no-sub">
                        <a href="{{route('fare')}}">
                            <i class="ph-fill  ph-money"></i>
                            &nbsp; Fare Managment
                        </a>
                    </li>
                    @endcan

                    <li class="no-sub">
                        <a href="{{route('account-delete-requests')}}">
                            <i class="ph-fill  ph-trash"></i>
                            &nbsp; Account Delete request
                        </a>
                    </li>
                    @can('banners')
                    <li class="no-sub">
                        <a href="{{route('banners')}}">
                            <i class="ph-fill  ph-images"></i>
                            &nbsp; Banners
                        </a>
                    </li>
                    @endcan
                    @can('role-list')
                    <li class="no-sub">
                        <a href="{{ route('roles.index') }}">
                            <i class="ph-fill  ph-user-circle-gear"></i>
                            &nbsp; Role Management
                        </a>
                    </li>
                    @endcan
                    @can('user-list')
                    <li class="no-sub">
                        <a href="{{ route('users.index') }}">
                            <i class="ph-fill  ph-user-switch"></i>
                            &nbsp; User Managment
                        </a>
                    </li>
                    @endcan
                    @can('settings')
                    <li class="no-sub">
                        <a href="{{route('settings')}}">
                            <i class="ph-duotone  ph-gear pe-1 f-s-20"></i>
                            &nbsp; Settings
                        </a>
                    </li>
                    @endcan

                    @can('faq')
                    <li class="no-sub">
                        <a href="{{route('faq')}}">
                            <i class="ph-duotone  ph-question pe-1 f-s-20"></i>
                            &nbsp; faq
                        </a>
                    </li>
                    @endcan
                </ul>
            </div>

            <div class="menu-navs">
                <span class="menu-previous"><i class="ti ti-chevron-left"></i></span>
                <span class="menu-next"><i class="ti ti-chevron-right"></i></span>
            </div>

        </nav>
        <!-- Menu Navigation ends -->
        <!-- Menu Navigation end -->


        <div class="app-content">
            <!-- Header Section start -->
            <!-- Header Section starts -->
            <header class="header-main">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-8 col-sm-6 d-flex align-items-center header-left p-0">
                            <span class="header-toggle ">
                                <i class="ph ph-squares-four"></i>
                            </span>


                        </div>

                        <div class="col-4 col-sm-6 d-flex align-items-center justify-content-end header-right p-0">

                            <ul class="d-flex align-items-center">
                                <li class="header-apps">
                                    <a aria-controls="appscanvasRights"
                                        class="d-block head-icon bg-light-dark rounded-circle f-s-22 p-2"
                                        data-bs-target="#appscanvasRights" data-bs-toggle="offcanvas"
                                        href="#" role="button">
                                        <i class="ph ph-bounding-box"></i>

                                    </a>

                                    <div aria-labelledby="appscanvasRightsLabel"
                                        class="offcanvas offcanvas-end header-apps-canvas"
                                        id="appscanvasRights"
                                        tabindex="-1">
                                        <div class="offcanvas-header">
                                            <h5 class="offcanvas-title" id="appscanvasRightsLabel">Shortcut</h5>
                                            <div class="app-dropdown flex-shrink-0">
                                                <a aria-expanded="false" class=" p-1" data-bs-auto-close="outside"
                                                    data-bs-toggle="dropdown"
                                                    href="#"
                                                    role="button">
                                                    <i class="ph-bold  ph-faders-horizontal f-s-20"></i>


                                                </a>
                                                <ul class="dropdown-menu mb-3">
                                                    <li class="dropdown-item">
                                                        <a href="setting.html" target="_blank">
                                                            Privacy Settings
                                                        </a>
                                                    </li>
                                                    <li class="dropdown-item">
                                                        <a href="setting.html" target="_blank">
                                                            Account Settings
                                                        </a>
                                                    </li>
                                                    <li class="dropdown-item">
                                                        <a href="setting.html" target="_blank">
                                                            Accessibility
                                                        </a>
                                                    </li>
                                                    <li class="dropdown-divider"></li>
                                                    <li class="dropdown-item border-0">
                                                        <a aria-expanded="false" data-bs-toggle="dropdown" href="#"
                                                            role="button">
                                                            More Settings
                                                        </a>
                                                        <ul class="dropdown-menu sub-menu">
                                                            <li class="dropdown-item">
                                                                <a href="setting.html" target="_blank">
                                                                    Backup and Restore
                                                                </a>
                                                            </li>
                                                            <li class="dropdown-item">
                                                                <a href="setting.html" target="_blank">
                                                                    <span>Data Usage</span>
                                                                </a>
                                                            </li>
                                                            <li class="dropdown-item">
                                                                <a href="setting.html" target="_blank">
                                                                    <span>Theme</span>
                                                                </a>
                                                            </li>
                                                            <li class="dropdown-item d-flex align-items-center justify-content-between">
                                                                <a href="#">
                                                                    <p class="mb-0">Notification</p>
                                                                </a>
                                                                <div class="flex-shrink-0">
                                                                    <div class="form-check form-switch">
                                                                        <input class="form-check-input  form-check-primary"
                                                                            id="notificationSwitch"
                                                                            type="checkbox">
                                                                    </div>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="offcanvas-body app-scroll">
                                            <div class="row row-cols-3 g-2">
                                                <div class="d-flex-center text-center">
                                                    <a class="text-light-primary w-100 rounded-3 py-3 px-2 "
                                                        href="product.html"
                                                        target="_blank">
                                                        <span>
                                                            <i class="ph-light  ph-shopping-bag-open  f-s-30"></i>
                                                        </span>
                                                        <p class="mb-0 f-w-500 text-dark">E-shop</p>
                                                    </a>
                                                </div>
                                                <div class="d-flex-center text-center">
                                                    <a class="text-light-danger w-100 rounded-3 py-3 px-2 "
                                                        href="email.html"
                                                        target="_blank">
                                                        <span>
                                                            <i class="ph-light  ph-envelope  f-s-30"></i>
                                                        </span>
                                                        <p class="mb-0 f-w-500 text-dark">Email</p>
                                                    </a>
                                                </div>
                                                <div class="d-flex-center text-center">
                                                    <a class="text-light-success w-100 rounded-3 py-3 px-2 "
                                                        href="chat.html"
                                                        target="_blank">
                                                        <span>
                                                            <i class="ph-light  ph-chat-circle-text  f-s-30"></i>
                                                        </span>
                                                        <p class="mb-0 f-w-500 text-dark">Chat</p>
                                                    </a>
                                                </div>
                                                <div class="d-flex-center text-center">
                                                    <a class="text-light-warning w-100 rounded-3 py-3 px-2 "
                                                        href="project_app.html"
                                                        target="_blank">
                                                        <span>
                                                            <i class="ph-light  ph-projector-screen-chart  f-s-30"></i>
                                                        </span>
                                                        <p class="mb-0 f-w-500 text-dark">Project</p>
                                                    </a>
                                                </div>
                                                <div class="d-flex-center text-center">
                                                    <a class="text-light-info w-100 rounded-3 py-3 px-2 "
                                                        href="invoice.html"
                                                        target="_blank">
                                                        <span>
                                                            <i class="ph-light  ph-scroll f-s-30"></i>
                                                        </span>
                                                        <p class="mb-0 f-w-500 text-dark">Invoice</p>
                                                    </a>
                                                </div>
                                                <div class="d-flex-center text-center">
                                                    <a class="text-light-dark w-100 rounded-3 py-3 px-2 "
                                                        href="blog.html"
                                                        target="_blank">
                                                        <span>
                                                            <i class="ph-light  ph-notebook f-s-30"></i>
                                                        </span>
                                                        <p class="mb-0 f-w-500 text-dark">Blog</p>
                                                    </a>
                                                </div>
                                                <div class="d-flex-center text-center">
                                                    <a class="text-light-danger w-100 rounded-3 py-3 px-2 "
                                                        href="calendar.html"
                                                        target="_blank">
                                                        <span>
                                                            <i class="ph-light  ph-calendar f-s-30"></i>
                                                        </span>
                                                        <p class="mb-0 f-w-500 text-dark">Calender</p>
                                                    </a>
                                                </div>
                                                <div class="d-flex-center text-center">
                                                    <a class="text-light-warning w-100 rounded-3 py-3 px-2 "
                                                        href="file_manager.html"
                                                        target="_blank">
                                                        <span>
                                                            <i class="ph-light  ph-folder-open f-s-30"></i>
                                                        </span>
                                                        <p class="mb-0 f-w-500 text-dark txt-ellipsis-1">File
                                                            Manager</p>
                                                    </a>
                                                </div>
                                                <div class="d-flex-center text-center">
                                                    <a class="text-light-primary w-100 rounded-3 py-3 px-2 "
                                                        href="gallery.html"
                                                        target="_blank">
                                                        <span>
                                                            <i class="ph-light  ph-google-photos-logo f-s-30"></i>
                                                        </span>
                                                        <p class="mb-0 f-w-500 text-dark">Gallery</p>
                                                    </a>
                                                </div>
                                                <div class="d-flex-center text-center">
                                                    <a class="text-light-success w-100 rounded-3 py-3 px-2 "
                                                        href="profile.html"
                                                        target="_blank">
                                                        <span>
                                                            <i class="ph-light  ph-users-three f-s-30"></i>
                                                        </span>
                                                        <p class="mb-0 f-w-500 text-dark">Profile</p>
                                                    </a>
                                                </div>
                                                <div class="d-flex-center text-center">
                                                    <a class="text-light-secondary w-100 rounded-3 py-3 px-2 "
                                                        href="kanban_board.html"
                                                        target="_blank">
                                                        <span>
                                                            <i class="ph-light  ph-selection-foreground f-s-30"></i>
                                                        </span>
                                                        <p class="mb-0 f-w-500 text-dark">Task Board</p>
                                                    </a>
                                                </div>
                                                <div class="d-flex-center text-center">
                                                    <a class="d-flex-center text-light-secondary w-100 h-100 rounded-3 p-2 dashed-1-secondary"
                                                        href="kanban_board.html"
                                                        target="_blank">
                                                        <span>
                                                            <i class="ph-light  ph-plus f-s-30"></i>
                                                        </span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>

                                <li class="header-dark">
                                    <div class="sun-logo head-icon bg-light-dark rounded-circle f-s-22 p-2">
                                        <i class="ph ph-moon-stars"></i>
                                    </div>
                                    <div class="moon-logo head-icon bg-light-dark rounded-circle f-s-22 p-2">
                                        <i class="ph ph-sun-dim"></i>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Header Section ends -->
            <!-- Header Section end -->
            @yield('content')

            <!-- Main Section end -->
        </div>

        <!-- tap on top -->
        <div class="go-top">
            <span class="progress-value">
                <i class="ti ti-arrow-up"></i>
            </span>
        </div>
        <!-- Footer Section start -->
        <!-- Footer Section starts-->
        <footer>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 col-12">
                        <p class="footer-text f-w-600 mb-0">Copyright Â© 2025 Rido. All rights reserved ðŸ’– </p>
                    </div>

                </div>
            </div>
        </footer>
        <!-- Footer Section ends-->
        <!-- Footer Section end -->
    </div>

    <!--customizer-->
    <div id="customizer"></div>

    <!-- scripts start-->
    <!-- latest jquery-->


    <!-- Bootstrap js-->
    <script src="{{asset('assets/vendor/bootstrap/bootstrap.bundle.min.js')}}"></script>

    <!-- Simple bar js-->
    <script src="{{asset('assets/vendor/simplebar/simplebar.js')}}"></script>

    <!-- phosphor js -->
    <script src="{{asset('assets/vendor/phosphor/phosphor.js')}}"></script>

    <!-- Customizer js-->
    <script src="{{asset('assets/js/customizer.js')}}"></script>

    <!-- prism js-->
    <script src="{{asset('assets/vendor/prism/prism.min.js')}}"></script>

    <!-- App js-->
    <script src="{{asset('assets/js/script.js')}}"></script>

    <!-- flatpickr js-->
    <script src="{{asset('assets/vendor/datepikar/flatpickr.js')}}"></script>

    <!--js-->
    <script src="{{asset('assets/js/date_picker.js')}}"></script>
    <!-- apexcharts js-->
    <!-- <script src="{{asset('assets/vendor/apexcharts/apexcharts.min.js')}}"></script> -->

    <!-- Glight js -->
    <script src="{{asset('assets/vendor/glightbox/glightbox.min.js')}}"></script>

    <!-- Ecommerce js-->
    <!-- <script src="{{asset('assets/js/ecommerce_dashboard.js')}}"></script> -->


    <!-- 
    <script src="{{asset('assets/assets/js/product_list.js')}}"></script> -->


    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.4/toastr.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.4/toastr.css" />
    <!-- scripts end-->


    <!-- select2 -->
    <script src="{{asset('assets/vendor/select/select2.min.js')}}"></script>

    <!--js-->
    <script src="{{asset('assets/js/select.js')}}"></script>


    <!-- filepond -->
    <script src="{{asset('assets/vendor/filepond/file-encode.min.js')}}"></script>
    <script src="{{asset('assets/vendor/filepond/validate-size.min.js')}}"></script>
    <script src="{{asset('assets/vendor/filepond/validate-type.js')}}"></script>
    <script src="{{asset('assets/vendor/filepond/exif-orientation.min.js')}}"></script>
    <script src="{{asset('assets/vendor/filepond/image-preview.min.js')}}"></script>
    <script src="{{asset('assets/vendor/filepond/filepond.min.js')}}"></script>

    <!-- phosphor js -->
    <script src="{{asset('assets/vendor/phosphor/phosphor.js')}}"></script>

    <!-- js -->
    <script src="{{asset('assets/js/file_upload.js')}}"></script>

    <script src="{{asset('assets/js/team.js')}}"></script>

    <!-- slick-file -->
    <script src="{{asset('assets/vendor/slick/slick.min.js')}}"></script>
    <script src="{{asset('assets/js/slick.js')}}"></script>
    <script src="{{asset('assets/vendor/shepherdjs/shepherd.js')}}"></script>
    <!-- Glight js -->
    <script src="{{asset('assets/vendor/glightbox/glightbox.min.js')}}"></script>
    <script src="{{asset('assets/vendor/masonry/masonry.pkgd.min.js')}}"></script>

    <!-- js -->
    <script src="{{asset('assets/js/glightbox.js')}}"></script>
    <script type="text/javascript">
        @session("success")
        toastr.success("{{ $value }}", "Success");
        @endsession

        @session("info")
        toastr.info("{{ $value }}", "Info");
        @endsession

        @session("warning")
        toastr.warning("{{ $value }}", "Warning");
        @endsession

        @session("error")
        toastr.error("{{ $value }}", "Error");
        @endsession


        document.addEventListener('DOMContentLoaded', function() {
            const tableContainer = document.querySelector('.table-responsive');

            tableContainer.addEventListener('wheel', function(event) {
                if (event.deltaY !== 0) {
                    tableContainer.scrollLeft += event.deltaY;
                    event.preventDefault();
                }
            });
        });
    </script>



</body>

</html>