@extends('layouts.template')

@section('content')

        <!-- Main Section start -->
        <main>
            
     <div class="container-fluid">

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                    <h4>Edit Fare Managment</h4>
                </div>
                    <div class="card-body px-5">
                         <form action="{{route('update-fare')}}" method="post" enctype="multipart/form-data">
                                @csrf
                                 <div class="row">
                                                 <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Vehicle Type</label>
                                                             <input type="hidden" value="{{$data->id}}" name="id">
                                                            <select class="form-control" name="vehicle_type_id" required>
                                                                <option value="">Select type</option>
                                                             @foreach(App\Models\VehicleCategory::where('status','ACTIVE')->get() as $item)
                                                                    <option value="{{$item->id}}" {{ $data->vehicle_type_id == $item->id ? 'selected' : '' }}>{{$item->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                   
                                                    

                                                    <div class="col-md-6">                                 
                                                        <div class="mb-3">
                                                            <label class="form-label">Base Fare </label>
                                                            <input type="number"  name="base_rate"  value="{{$data->base_rate}}" class="form-control" required >
                                                        </div>
                                                    </div>
                                                    
                                                     <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label">Zone</label>
                                                           <select class="select-basic-multiple-four w-100 select_primary" multiple="multiple" name="city_id[]" required>
                                                               <option value="">Select Zone</option>
                                                                @foreach(App\Models\Zone::where('status','ACTIVE')->get() as $item)
                                                                    <option value="{{$item->id}}"  {{ in_array($item->id,json_decode($data->city_id, true) ?? []) ? 'selected' : '' }}>{{$item->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>

                                                     <div class="col-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Base KM </label>
                                                            <input type="number" value="{{$data->base_km}}" name="base_km" class="form-control">
                                                        </div>
                                                    </div>

                                                    <div class="col-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Additional KM Rate</label>
                                                            <input type="number" name="additional_rate_per_km" value="{{$data->additional_km_rate}}" required class="form-control">                                            
                                                        </div>
                                                    </div>

                                                                                                                                                                                                   
                                                 <div class="col-md-4">
                                                        <div class="mb-3 floating-select">
                                                            <label class="form-label">Surge charge in % <span class="text-secondary f-s-12">(Optional)</span></label>
                                                            <input type="number" class="form-control" value="{{$data->surge_charge}}"  name="surge_charge">
                                                        </div>
                                                    </div>

                                                    <div class="col-md-4">
                                                        <div class="mb-3">
                                                            <label class="form-label">Surcharge Start Date <span class="text-secondary f-s-12">(Optional)</span></label>
                                                             <div class="input-group dates">
                                                                <input class="form-control basic-date"  type="text" value="{{$data->surcharge_start_date}}" name="surcharge_start_date">
                                                            </div>
                                                        </div>
                                                    </div>
                                                  <div class="col-md-4">
                                                        <div class="mb-3">
                                                            <label class="form-label">Surcharge End Date <span class="text-secondary f-s-12">(Optional)</span></label>
                                                             <div class="input-group dates">
                                                                <input class="form-control basic-date"  type="text" value="{{$data->surcharge_end_date}}" name="surcharge_end_date">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="col-md-4">
                                                        <div class="mb-3">
                                                            <label class="form-label">Offer Charges in % <span class="text-secondary f-s-12">(Optional)</span></label>
                                                            <input type="number" class="form-control"  value="{{$data->offer_charge}}" name="offer_charge">
                                                        </div>
                                                    </div>
                                                   
                                                 <div class="col-md-4">
                                                        <div class="mb-3">
                                                            <label class="form-label">Offer Start Date <span class="text-secondary f-s-12">(Optional)</span></label>
                                                             <div class="input-group dates">
                                                                <input class="form-control basic-date" type="text" value="{{$data->offer_start_date}}" name="offer_start_date">
                                                            </div>
                                                        </div>
                                                    </div>
                                                  <div class="col-md-4">
                                                        <div class="mb-3">
                                                            <label class="form-label">Offer End Date <span class="text-secondary f-s-12">(Optional)</span></label>
                                                             <div class="input-group dates">
                                                                <input class="form-control basic-date"  type="text" value="{{$data->offer_end_date}}" name="offer_end_date">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                     
                                                    <div class="col-12 mt-3">
                                                        <div class="text-end">
                                                            <button type="submit" class="btn btn btn-primary">SAVE </button>
                                                        </div>
                                                  </div>
                                 </div>
                         </div>
                     </form>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
        </main>
      
   <script type="text/javascript">
     
    </script>
  @endsection
