@extends('layouts.template')

@section('content')

<!-- Main Section start -->
<main>

    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12 ">
                <h4 class="main-title">Brand / Models/ Fare Managment</h4>

                <div style="float:right;    margin-top: -51px;    display: flex;">
                    @can('add-brand')
                    <button type="button" class="btn btn-primary btn-lg w-100 " data-bs-toggle="modal"
                        data-bs-target="#brand"><i class="ti ti-plus"></i> Add Brand</button>
                    <div class="modal fade" id="brand" tabindex="-1" aria-labelledby="exampleModalLabel"
                        aria-hidden="true">
                        <form action="{{route('add-brand')}}" method="post">
                            @csrf
                            <div class="modal-dialog modal-dialog-centered" id="staticBackdrop">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h1 class="modal-title f-w-500 fs-5" id="exampleModalLabel1">Add Brand</h1>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body app-form">
                                        <div class="mb-3" id="newtask">
                                            <label class="form-label">Brand Name</label>
                                            <input class="form-control todo-inputs" name="name" required type="text">
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-primary" type="submit" id="push"
                                            data-bs-dismiss="modal">Save changes</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    @endcan

                    @can('add-brand-model')
                    <button type="button" class="btn btn-primary btn-lg w-100 " data-bs-toggle="modal"
                        data-bs-target="#exampleModal"><i class="ti ti-plus"></i> Add Model</button>
                    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                        aria-hidden="true">
                        <form action="{{route('add-brand-model')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="modal-dialog modal-dialog-centered" id="staticBackdrop">
                                <div class="modal-content modal-lg">
                                    <div class="modal-header">
                                        <h1 class="modal-title f-w-500 fs-5" id="exampleModalLabel1">Create Model Name</h1>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body app-form">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Vehicle Type</label>
                                                    <select class="form-control" name="vehicle_type" required>
                                                        <option value="">---Select Vehicle Type---</option>
                                                        @foreach(App\Models\VehicleCategory::where('status','ACTIVE')->get() as $item)
                                                        <option value="{{$item->id}}">{{$item->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Brand </label>
                                                    <select class="form-control" name="brand" required>
                                                        <option value="">---Select Brand---</option>
                                                        @foreach(App\Models\Brand::get() as $item)
                                                        <option value="{{$item->id}}">{{$item->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-12">

                                            <div class="mb-3">
                                                <label class="form-label">Model Name </label>
                                                <input type="text" class="form-control" name="model_name" required>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Minimum Passengers</label>
                                                    <input type="number" name="min_passengers" class="form-control" required>
                                                </div>
                                            </div>

                                            <div class="col-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Maximum Passengers</label>
                                                    <input type="number" name="max_passengers" required class="form-control">

                                                </div>
                                            </div>
                                        </div>
                                        <!-- <div class="row">
                                                <div class="col-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Base fare</label>
                                                            <input type="number" name="base_fare" class="form-control" oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                                                        </div>
                                                    </div>

                                                     <div class="col-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Fare per Kilometer</label>
                                                            <input type="number" name="fare_per_km" required class="form-control" oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                                                         
                                                        </div>
                                                    </div>
                                            </div> -->

                                    </div>

                                    <div class="modal-footer">
                                        <button class="btn btn-primary" type="submit" id="push"
                                            data-bs-dismiss="modal">Save changes</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    @endcan

                </div>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-body px-0">
                        <div class=" table-responsive app-scroll app-datatable-default product-list-table">
                            <table id="product-Listtable" class="table table-sm display align-middle">
                                <thead>
                                    <tr>
                                        <th>
                                            #
                                        </th>
                                        <th>Modal Name</th>
                                        <th>Brand</th>
                                        <th>Vehicle Type</th>
                                        <th>Min. Passengers</th>
                                        <th>Max. Passengers</th>
                                        <!-- <th>Base Fare</th>
                                     <th>Fare per km</th> -->
                                        <th>Action</th>
                                    </tr>
                                </thead>

                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
</main>

<script type="text/javascript">
    $(function() {

        $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-brandmodel') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'brand',
                    name: 'brand'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'min',
                    name: 'min'
                },
                {
                    data: 'max',
                    name: 'max'
                },

                //  {
                //     data: 'base_fare',
                //     name: 'base_fare'
                // },
                //   {
                //     data: 'per_km',
                //     name: 'per_km'
                // },
                {
                    data: 'action',
                    name: 'action'
                },

            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row 
            },
        });
    });
</script>
@endsection