@extends('layouts.login-template')

@section('content')
<div class="app-wrapper d-block">
    <div class="">
        <!-- Body main section starts -->
        <main class="w-100 p-0">
            <!-- Login to your Account start -->
            <div class="container-fluid">
                <div class="row">

                    <div class="col-12 p-0">
                        <div class="login-form-container" style="background-image:url('{{asset('build/assets/06-BUZdJH04.jpg')}}');">
                            <div class="mb-4">
                                <a class="logo" href="/">
                                    <img alt="#" src="{{asset('assets/images/logo/3.png')}}" class="" style="width:100%;">
                                </a>
                            </div>
                            <div class="form_container">
                                <form method="POST" action="{{ route('login') }}" class="app-form">
                                  @csrf
                               
                                    <div class="mb-3 text-center">
                                        <h3>Login to your Account</h3>
                                    
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="emailId">Email address</label>
                                         <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>

                                        @error('email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                        
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="password">Password</label>
                                        <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password">

                                        @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="mb-3 form-check">
                                         <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="formCheck1">remember me</label>
                                    </div>
                                    <div>
                                           <button type="submit" class="btn btn-primary w-100">
                                    {{ __('Login') }}
                                </button>
                                        
                                    </div>
                                    <div class="app-divider-v justify-content-center">
                                        <p>OR</p>
                                    </div>
                                 
                                    <div class="text-center">
                                          @if (Route::has('password.request'))
                                    <a class="btn btn-link" href="{{ route('password.request') }}">
                                        {{ __('Forgot Your Password?') }}
                                    </a>
                                @endif
                                     
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Login to your Account end -->
        </main>
        <!-- Body main section ends -->
    </div>
</div>
@endsection
