<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reviews', function (Blueprint $table) {
              $table->id();
              $table->integer('booking_id');
              $table->integer('user_id');
              $table->integer('vehicle_id')->nullable();
              $table->integer('driver_id')->nullable();
              $table->tinyInteger('overall_rating')->nullable(); // 1–5
              $table->tinyInteger('driver_rating')->nullable();  // 1–5
              $table->tinyInteger('car_rating')->nullable();     // 1–5
              $table->text('comment')->nullable();           
              $table->timestamp('created_at')->useCurrent();
              $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reviews');
    }
};
