<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('search_histories', function (Blueprint $table) {
                $table->id();
                $table->integer('user_id');
                $table->date('departure_date');
                $table->date('return_date');     
                $table->string('departure_time');
                $table->string('return_time');
                $table->string('pick_up');       
                $table->string('drop_off');  
                $table->json('stay_date')->nullable();    
                $table->json('stay_locations')->nullable();        // after base distance
                $table->integer('adults');               
                $table->integer('children');  
                $table->string('client_name');
                $table->string('client_mobile_number');
                $table->string('client_email');  
                $table->timestamp('created_at')->useCurrent();
                $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('search_histories');
    }
};
