<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('drivers', function (Blueprint $table) {
             $table->id();
             $table->integer('vendor_id')->nullable();
             $table->string('name');
             $table->string('phone')->unique();
             $table->string('address');
             $table->string('aadhar_no');
             $table->string('image');
             $table->string('licence_number');
             $table->date('licence_validity');
             $table->string('licence');
             $table->integer('total_rides')->default('0');
             $table->string('is_availabile_status')->default('True');
             $table->integer('zone');
             $table->string('status')->default('ACTIVE');
             $table->timestamp('created_at')->useCurrent();
             $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('drivers');
    }
};
